/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.PostProcessParameterAction;
import io.intino.consul.box.service.RequestAttendant;

public class ParameterRequest
implements RequestAttendant {
    private final ConsulBox box;

    public ParameterRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String responseTo(String request) {
        try {
            Message message = new MessageReader(request).next();
            return this.actionFor(message.get("processId").asString(), message.get("name").asString(), message.get("value").asString()).execute().toString();
        }
        catch (Throwable e) {
            Logger.error(e);
            return e.getMessage();
        }
    }

    private PostProcessParameterAction actionFor(String processId, String name, String value) {
        PostProcessParameterAction action = new PostProcessParameterAction();
        action.box = this.box;
        action.process = processId;
        action.name = name;
        action.value = value;
        return action;
    }
}

