/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.cesar.datahub.events.Deploy;
import io.intino.cesar.datahub.events.DeployResult;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.DeployAction;
import io.intino.consul.box.service.RequestAttendant;

public class DeployRequest
implements RequestAttendant {
    private final ConsulBox box;

    public DeployRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String responseTo(String request) {
        try {
            if (this.box.isShuttingDown().get()) {
                return new DeployResult().success(false).remarks("Deploy not processed. Consul is shutting down...").toMessage().toString();
            }
            return this.actionFor(new Deploy(new MessageReader(request).next())).execute().toMessage().toString();
        }
        catch (Throwable e) {
            Logger.error(e);
            return e.getMessage();
        }
    }

    private DeployAction actionFor(Deploy process) {
        DeployAction action = new DeployAction();
        action.box = this.box;
        action.deploy = process;
        return action;
    }
}

