/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.StartProcessAction;
import io.intino.consul.box.oshi.ServerInfoProvider;
import io.intino.consul.box.process.ProcessStopListener;
import io.intino.consul.model.Info;
import io.intino.consul.model.Process;
import java.time.Instant;

public class RestartProcessOnStop
implements ProcessStopListener {
    private final ConsulBox box;

    public RestartProcessOnStop(ConsulBox box) {
        this.box = box;
    }

    @Override
    public void onStop(Process process, int exitCode) {
        try {
            if (this.box.isShuttingDown().get()) {
                return;
            }
            Thread.sleep(5000L);
            process.status(Process.Status.Stopped).save$();
            if (exitCode != 0 && this.box.configuration().scope().equalsIgnoreCase(Info.Scope.EXP.name())) {
                new StartProcessAction(this.box, process.identifier()).execute();
            }
            this.box.terminal().publish(this.defaultStatus(process).exitValue(exitCode));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ProcessStatus defaultStatus(Process process) {
        ServerInfoProvider manager = new ServerInfoProvider();
        return new ProcessStatus().ts(Instant.now()).id(process.identifier()).running(!process.status().equals((Object)Process.Status.Stopped)).serverId(this.box.serverId()).workspaceSize(Double.valueOf(manager.directoryTotalSize(process.workspace()))).workspaceTotalSize(Double.valueOf(manager.directoryTotalSize(process.workspace()))).openFiles(manager.openFiles(process.pid()));
    }
}

