/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.cesar.datahub.events.OperationResult;
import io.intino.cesar.datahub.events.Operations;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.process.ProcessConnector;
import io.intino.consul.box.process.ProcessManager;
import io.intino.consul.model.Process;

public class ProcessOperationAction {
    public ConsulBox box;
    public Operations.Operation operation;

    public OperationResult execute() {
        Process process = ProcessFinder.processFromIdentifier(this.box.graph(), this.operation.processId());
        ProcessManager processManager = this.box.processManager();
        boolean running = processManager.isRunning(ProcessFinder.processFromIdentifier(this.box.graph(), this.operation.processId()));
        if (!running) {
            return new OperationResult().success(false).remarks("Process is not running");
        }
        ProcessConnector connector = new ProcessConnector(process);
        try {
            connector.connect();
            OperationResult invoke = connector.invoke(this.operation);
            connector.disconnect();
            return invoke;
        }
        catch (Throwable e) {
            return new OperationResult().success(false).remarks(e.getMessage());
        }
    }
}

