/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.scheduling.CheckServerInfoChangesListener;
import io.intino.consul.box.scheduling.NotifyBootListener;
import io.intino.consul.box.scheduling.ScheduleProcessStatusListener;
import io.intino.consul.box.scheduling.ScheduleServerStatusListener;
import io.intino.consul.box.scheduling.StartProcessLogListener;
import io.intino.consul.box.scheduling.StartWindowsProcessesOnBootListener;
import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private Sentinels() {
    }

    public static void init(AlexandriaScheduler scheduler, File home, ConsulBox box) {
        try {
            JobDetail job = JobBuilder.newJob(NotifyBootListener.class).withIdentity("notifyBoot").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().startAt(Date.from(Instant.now().plus(1000L, ChronoUnit.MILLIS))).build()), true);
            job = JobBuilder.newJob(StartWindowsProcessesOnBootListener.class).withIdentity("startWindowsProcessesOnBoot").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().startAt(Date.from(Instant.now().plus(3000L, ChronoUnit.MILLIS))).build()), true);
            job = JobBuilder.newJob(CheckServerInfoChangesListener.class).withIdentity("checkServerInfoChanges").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("Interface#checkServerInfoChanges").withSchedule(CronScheduleBuilder.cronSchedule("0 0/1 * 1/1 * ? *").inTimeZone(TimeZone.getTimeZone(ZoneId.of("Atlantic/Canary")))).build()), true);
            job = JobBuilder.newJob(ScheduleServerStatusListener.class).withIdentity("scheduleServerStatus").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("Interface#scheduleServerStatus").withSchedule(CronScheduleBuilder.cronSchedule("0 0/15 * 1/1 * ? *").inTimeZone(TimeZone.getTimeZone(ZoneId.of("Atlantic/Canary")))).build()), true);
            job = JobBuilder.newJob(ScheduleProcessStatusListener.class).withIdentity("scheduleProcessStatus").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("Interface#scheduleProcessStatus").withSchedule(CronScheduleBuilder.cronSchedule("0 0/15 * 1/1 * ? *").inTimeZone(TimeZone.getTimeZone(ZoneId.of("Atlantic/Canary")))).build()), true);
            job = JobBuilder.newJob(StartProcessLogListener.class).withIdentity("startProcessLog").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().startNow().build()), true);
            scheduler.startSchedules();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    private static Set<Trigger> newSet(Trigger ... triggers) {
        LinkedHashSet<Trigger> set = new LinkedHashSet<Trigger>();
        Collections.addAll(set, triggers);
        return set;
    }
}

