/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.event.Event;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.datahub.events.consul.server.ServerBoot;
import io.intino.cesar.datahub.events.consul.server.ServerInfo;
import io.intino.cesar.datahub.events.consul.server.ServerLog;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import io.intino.consul.box.DatahubConnector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ConsulTerminal {
    private final DatahubConnector connector;
    private final Map<BiConsumer<?, String>, List<Consumer<Event>>> consumers = new HashMap();

    public ConsulTerminal(DatahubConnector connector) {
        this.connector = connector;
    }

    public void publish(Object event, String split) {
        if (event instanceof ProcessLog) {
            this.publish((ProcessLog)event);
        }
        if (event instanceof ProcessStatus) {
            this.publish((ProcessStatus)event);
        }
        if (event instanceof ServerBoot) {
            this.publish((ServerBoot)event);
        }
        if (event instanceof ServerInfo) {
            this.publish((ServerInfo)event);
        }
        if (event instanceof ServerLog) {
            this.publish((ServerLog)event);
        }
        if (event instanceof ServerStatus) {
            this.publish((ServerStatus)event);
        }
    }

    public void publish(ProcessLog processLog) {
        this.connector.sendEvent("consul.process.ProcessLog", processLog);
    }

    public void publish(ProcessStatus processStatus) {
        this.connector.sendEvent("consul.process.ProcessStatus", processStatus);
    }

    public void publish(ServerBoot serverBoot) {
        this.connector.sendEvent("consul.server.ServerBoot", serverBoot);
    }

    public void publish(ServerInfo serverInfo) {
        this.connector.sendEvent("consul.server.ServerInfo", serverInfo);
    }

    public void publish(ServerLog serverLog) {
        this.connector.sendEvent("consul.server.ServerLog", serverLog);
    }

    public void publish(ServerStatus serverStatus) {
        this.connector.sendEvent("consul.server.ServerStatus", serverStatus);
    }
}

