/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ingestion;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Session;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.ingestion.SetSessionFileWriter;
import io.intino.alexandria.ingestion.SetSessionWriter;
import io.intino.alexandria.triplestore.TripleStore;
import java.util.Arrays;
import java.util.stream.Stream;

public class SetSession {
    private TripleStore.Builder tripleStore;
    private final SessionHandler.Provider provider;
    private final int autoFlush;
    private SetSessionWriter writer;
    private int count = 0;

    public SetSession(SessionHandler.Provider provider) {
        this(provider, 1000000);
    }

    public SetSession(SessionHandler.Provider provider, int autoFlush) {
        this.provider = provider;
        this.autoFlush = autoFlush;
    }

    public void put(String tank, Timetag timetag, String set, Stream<Long> ids) {
        ids.forEach(i -> this.writer().add(tank, timetag, set, (long)i));
        if (this.count++ >= this.autoFlush) {
            this.doFlush();
        }
    }

    public void put(String tank, Timetag timetag, String set, long ... ids) {
        this.put(tank, timetag, set, Arrays.stream(ids).boxed());
    }

    public void define(String tank, Timetag timetag, String set, String variable, String value) {
        this.tripleStore().put(Fingerprint.of(tank, timetag, set).toString(), variable, value);
    }

    private SetSessionWriter writer() {
        return this.writer != null ? this.writer : (this.writer = new SetSessionFileWriter(this.provider.outputStream(Session.Type.set)));
    }

    private TripleStore.Builder tripleStore() {
        return this.tripleStore != null ? this.tripleStore : (this.tripleStore = new TripleStore.Builder(this.provider.outputStream(Session.Type.setMetadata)));
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.count = 0;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.tripleStore != null) {
            this.tripleStore.close();
        }
    }

    private void doFlush() {
        this.flush();
    }
}

