/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.datalake.file.FileSetTub;
import java.io.File;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileSetTank
implements Datalake.SetStore.Tank {
    private final File root;

    public FileSetTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Datalake.SetStore.Tub first() {
        return this.tubs().findFirst().orElse(null);
    }

    @Override
    public Datalake.SetStore.Tub last() {
        return FS.foldersIn(this.root, FS.Sort.Reversed).map(FileSetTub::new).findFirst().orElse(null);
    }

    @Override
    public Stream<Datalake.SetStore.Tub> tubs() {
        return FS.foldersIn(this.root).map(FileSetTub::new);
    }

    @Override
    public Stream<Datalake.SetStore.Tub> tubs(int count) {
        return FS.foldersIn(this.root, FS.Sort.Reversed).map(f -> new FileSetTub((File)f)).limit(count);
    }

    @Override
    public Stream<Datalake.SetStore.Tub> tubs(Timetag from, Timetag to) {
        return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::on);
    }

    @Override
    public Datalake.SetStore.Tub on(Timetag tag) {
        return new FileSetTub(new File(this.root, tag.value()));
    }

    public File root() {
        return this.root;
    }
}

