/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.io;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DeflateSerializer;
import io.intino.magritte.io.LocalDateTimeSerializer;
import io.intino.magritte.io.Stash;
import io.intino.magritte.io.StoreException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class ThreadSafeStashSerializer {
    private static final Map<String, Kryo> kryos = new ConcurrentHashMap<String, Kryo>();

    private ThreadSafeStashSerializer() {
    }

    public static byte[] serialize(Stash stash) {
        try {
            return ThreadSafeStashSerializer.doSerialize(stash);
        }
        catch (IOException e) {
            throw new StoreException(e.getMessage());
        }
    }

    private static byte[] doSerialize(Stash stash) throws IOException {
        String thread = Thread.currentThread().getName();
        if (!kryos.containsKey(thread)) {
            if (kryos.size() > 1000) {
                kryos.clear();
            }
            kryos.put(thread, ThreadSafeStashSerializer.newDeserializer());
        }
        Kryo kryo = kryos.get(thread);
        try (Output output = new Output(4096, -1);){
            kryo.writeObject(output, stash);
            output.flush();
            output.close();
            byte[] byArray = output.toBytes();
            return byArray;
        }
    }

    private static Kryo newDeserializer() {
        Kryo kryo = new Kryo();
        kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
        kryo.register(Stash.class, new DeflateSerializer(kryo.getDefaultSerializer(Stash.class)));
        kryo.register(LocalDateTime.class, new LocalDateTimeSerializer());
        return kryo;
    }
}

