/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.DebugProcessAction;
import io.intino.consul.box.service.RequestAttendant;

public class DebugProcessRequest
implements RequestAttendant {
    private final ConsulBox box;

    public DebugProcessRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public String responseTo(String request) {
        try {
            return this.actionFor(this.processId(request)).execute().toString();
        }
        catch (Throwable e) {
            Logger.error(e);
            return e.getMessage();
        }
    }

    private String processId(String request) {
        return new MessageReader(request).next().get("processId").asString();
    }

    private DebugProcessAction actionFor(String processId) {
        DebugProcessAction action = new DebugProcessAction();
        action.box = this.box;
        action.processId = processId;
        return action;
    }
}

