/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service;

import io.intino.alexandria.jms.MessageWriter;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.DatahubConnector;
import io.intino.consul.box.service.RequestAttendant;
import io.intino.consul.box.service.requests.DebugProcessRequest;
import io.intino.consul.box.service.requests.DeployRequest;
import io.intino.consul.box.service.requests.ParameterRequest;
import io.intino.consul.box.service.requests.ProcessLogRequest;
import io.intino.consul.box.service.requests.ProcessOperationRequest;
import io.intino.consul.box.service.requests.ProcessOperationsRequest;
import io.intino.consul.box.service.requests.ProcessStatusRequest;
import io.intino.consul.box.service.requests.RebootRequest;
import io.intino.consul.box.service.requests.RestartProcessRequest;
import io.intino.consul.box.service.requests.RetractRequest;
import io.intino.consul.box.service.requests.StartProcessRequest;
import io.intino.consul.box.service.requests.StatusRequest;
import io.intino.consul.box.service.requests.StopProcessRequest;
import io.intino.consul.box.service.requests.UpgradeRequest;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class ConsulJmsService {
    private final DatahubConnector connector;
    Map<String, RequestAttendant> actions = new HashMap<String, RequestAttendant>();

    public ConsulJmsService(DatahubConnector connector, ConsulBox box) {
        this.connector = connector;
        this.actions.put("status", new StatusRequest(box));
        this.actions.put("reboot", new RebootRequest(box));
        this.actions.put("deploy", new DeployRequest(box));
        this.actions.put("retract", new RetractRequest(box));
        this.actions.put("upgrade", new UpgradeRequest(box));
        this.actions.put("start", new StartProcessRequest(box));
        this.actions.put("stop", new StopProcessRequest(box));
        this.actions.put("debug", new DebugProcessRequest(box));
        this.actions.put("restart", new RestartProcessRequest(box));
        this.actions.put("parameter", new ParameterRequest(box));
        this.actions.put("processStatus", new ProcessStatusRequest(box));
        this.actions.put("processLog", new ProcessLogRequest(box));
        this.actions.put("processOperation", new ProcessOperationRequest(box));
        this.actions.put("processOperations", new ProcessOperationsRequest(box));
        connector.createServiceConsumer("service.consul." + box.serverId() + ".request", this::response);
    }

    private void response(Message m) {
        try {
            this.response(m.getJMSReplyTo(), this.message(m.getJMSCorrelationID(), this.action(m).responseTo(this.getText(m))));
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    private void response(Destination destination, Message message) {
        new Thread(() -> this.connector.serviceResponse(destination, message)).start();
    }

    private Message message(String messageId, String response) {
        try {
            Message msg = MessageWriter.write(response);
            msg.setJMSCorrelationID(messageId);
            return msg;
        }
        catch (JMSException e) {
            Logger.error(e);
            return null;
        }
    }

    private String getText(Message m) {
        try {
            return ((TextMessage)m).getText();
        }
        catch (JMSException e) {
            Logger.error(e);
            return "";
        }
    }

    private RequestAttendant action(Message m) {
        try {
            return this.actions.get(m.getStringProperty("request"));
        }
        catch (JMSException e) {
            Logger.error(e);
            return r -> "operation not found";
        }
    }
}

