/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process.unix;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.linuxservice.LinuxServiceGenerator;
import io.intino.consul.box.process.ProcessHandler;
import io.intino.consul.box.process.unix.LinuxProcessLogger;
import io.intino.consul.box.process.unix.SyncHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class LinuxProcessHandler
implements ProcessHandler {
    private final io.intino.consul.model.Process process;
    private final ConsulConfiguration conf;
    private final LinuxProcessLogger logger;
    private final transient SyncHandler syncHandler;

    public LinuxProcessHandler(io.intino.consul.model.Process process, ConsulConfiguration conf, LinuxProcessLogger logger2) {
        this.process = process;
        this.conf = conf;
        this.syncHandler = new SyncHandler(new File(conf.applicationsWorkspace()), conf.deployUser());
        this.logger = logger2;
    }

    @Override
    public int start() throws Exception {
        try {
            new LinuxServiceGenerator(this.process, this.conf).generate(false);
            Logger.info("Launching " + this.process.identifier() + "...");
            this.logger.log(this.process);
            this.logger.notifyStart(this.process);
            Process p = this.systemctl("start").start();
            p.waitFor(3L, TimeUnit.MINUTES);
            this.process.syncFileToServerList().forEach(server -> this.syncHandler.sync(server.directory(), server.targetServers()));
            return this.pid();
        }
        catch (IOException | InterruptedException e) {
            Logger.error(e);
            return -1;
        }
    }

    @Override
    public int debug() throws Exception {
        try {
            new LinuxServiceGenerator(this.process, this.conf).generate(true);
            Logger.info("Launching " + this.process.identifier() + " with debug port " + this.process.debugPort() + "...");
            this.logger.log(this.process);
            Process p = this.systemctl("start").start();
            p.waitFor(3L, TimeUnit.MINUTES);
            this.process.syncFileToServerList().forEach(server -> this.syncHandler.sync(server.directory(), server.targetServers()));
            return this.pid();
        }
        catch (IOException | InterruptedException e) {
            Logger.error(e);
            return -1;
        }
    }

    @Override
    public void stop() {
        try {
            Process p = this.systemctl("stop").start();
            p.waitFor(3L, TimeUnit.MINUTES);
            new ProcessBuilder("systemctl", "disable", this.serviceName()).inheritIO().start();
            if (this.syncHandler != null) {
                this.syncHandler.stop();
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.error(e);
        }
    }

    @Override
    public boolean isRunning() {
        try {
            return this.status().contains("active (running)");
        }
        catch (IOException | InterruptedException e) {
            Logger.error(e);
            return false;
        }
    }

    @Override
    public int exitValue() {
        String status = null;
        try {
            status = this.status();
            String statusStr = "status=";
            return Arrays.stream(status.split("\n")).filter(l -> l.trim().startsWith("Main PID:") && l.contains("status=")).map(l -> l.split("status=")[1].replace(")", "").trim().split("/")[0]).map(Integer::parseInt).findFirst().orElse(-1000);
        }
        catch (Throwable e) {
            Logger.error("Impossible to get exit value of " + this.process.artifact().identifier() + ";\n" + status);
            return -1000;
        }
    }

    private int pid() {
        try {
            String status = this.status();
            String prefix = "Main PID:";
            return Arrays.stream(status.split("\n")).filter(l -> l.trim().startsWith(prefix)).map(l -> l.replace(prefix, "").trim().split(" ")[0]).map(Integer::parseInt).findFirst().orElse(-1000);
        }
        catch (IOException | InterruptedException e) {
            Logger.error(e);
            return -1000;
        }
    }

    private ProcessBuilder systemctl(String command) {
        return new ProcessBuilder("systemctl", command, this.serviceName());
    }

    private String serviceName() {
        return this.conf.deployUser() + "-" + this.process.artifact().artifactId();
    }

    private String status() throws IOException, InterruptedException {
        Process process = this.systemctl("status").start();
        InputStream inputStream = process.getInputStream();
        process.waitFor();
        return new String(inputStream.readAllBytes());
    }
}

