/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.StartProcessAction;
import io.intino.consul.box.oshi.OSValidator;
import io.intino.consul.model.Process;

public class StartWindowsProcessesOnBootAction {
    public ConsulBox box;

    public void execute() {
        if (!OSValidator.isWindows()) {
            return;
        }
        for (Process process : this.box.graph().processList()) {
            if (StartWindowsProcessesOnBootAction.wasRunning(process)) {
                new StartProcessAction(this.box, process.identifier()).execute();
            }
            StartWindowsProcessesOnBootAction.waitAMoment();
        }
    }

    private static void waitAMoment() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
    }

    private static boolean wasRunning(Process process) {
        return process.status().equals((Object)Process.Status.Running);
    }
}

