/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.oshi.OSValidator;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Comparator;
import java.util.jar.Manifest;

public class Utils {
    public static boolean isServerUp(String host, Integer port) {
        boolean isUp;
        if ("".equals(host)) {
            isUp = true;
        } else {
            try {
                Socket s = new Socket();
                s.setReuseAddress(true);
                InetSocketAddress sa = new InetSocketAddress(host, (int)port);
                s.connect(sa, 150);
                isUp = true;
            }
            catch (Exception e) {
                isUp = false;
            }
        }
        return isUp;
    }

    public static void removeDirectory(File directory) {
        try {
            if (!directory.exists()) {
                return;
            }
            Files.walk(directory.toPath(), FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            Logger.error(e.getMessage());
        }
    }

    public static void changeOwner(File file, String user, String group) {
        if (!OSValidator.isUnix()) {
            return;
        }
        UserPrincipalLookupService lookupService = file.toPath().getFileSystem().getUserPrincipalLookupService();
        try {
            Files.setOwner(file.toPath(), lookupService.lookupPrincipalByName(user));
            GroupPrincipal groupPrincipal = lookupService.lookupPrincipalByGroupName(group);
            if (groupPrincipal != null) {
                PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                fileAttributeView.setGroup(groupPrincipal);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static String currentVersion() {
        try {
            String file = Utils.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            if (new File(file).isFile()) {
                URL url = new URL("jar:file:" + file + "!/META-INF/MANIFEST.MF");
                Manifest manifest = new Manifest(url.openStream());
                if (manifest.getMainAttributes().getValue("Implementation-Version") == null) {
                    return "1.0.0";
                }
                return manifest.getMainAttributes().getValue("Implementation-Version").trim();
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
        return "1.0.0";
    }
}

