/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.AbstractBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.ConsulTerminal;
import io.intino.consul.box.DatahubConnector;
import io.intino.consul.box.oshi.OSValidator;
import io.intino.consul.box.process.ProcessLogger;
import io.intino.consul.box.process.ProcessManager;
import io.intino.consul.box.process.unix.LinuxProcessLogger;
import io.intino.consul.box.process.win.WinProcessLogger;
import io.intino.consul.box.service.ConsulJmsService;
import io.intino.consul.model.ConsulGraph;
import io.intino.consul.model.Process;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.stores.FileSystemStore;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConsulBox
extends AbstractBox {
    private final String serverId;
    private DatahubConnector datahubConnector;
    private ConsulTerminal terminal;
    private ConsulJmsService jmsService;
    private ConsulGraph graph;
    private ProcessManager processManager;
    private File applicationsDirectory;
    private ProcessLogger processLogger;
    private File logsDirectory;
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);

    public ConsulBox(ConsulConfiguration configuration) {
        super(configuration);
        this.serverId = this.calculateServerId();
        this.init();
    }

    private void init() {
        if (this.configuration.logsDirectory() != null) {
            this.logsDirectory = this.configuration.logsDirectory();
        }
        this.applicationsDirectory = this.configuration.applicationsDirectory();
        if (this.configuration.applicationsWorkspace() != null) {
            this.configuration.args().put("applications_workspace", new File("/home/" + this.configuration().deployUser()).getAbsolutePath());
        }
        if (this.configuration.logsTruncate() == null) {
            this.configuration.args().put("logs_truncate", "true");
        }
        if (this.configuration.logsPublish() == null) {
            this.configuration.args().put("logs_publish", "true");
        }
        this.processManager = new ProcessManager(this);
    }

    @Override
    public Box put(Object o) {
        if (o instanceof Graph) {
            this.graph = ((Graph)o).as(ConsulGraph.class);
            if (this.logsDirectory == null) {
                this.logsDirectory = ((FileSystemStore)this.graph().core$().store()).directory();
            }
        }
        super.put(o);
        return this;
    }

    @Override
    public void beforeStart() {
        this.extractScripts();
        this.startConsulTerminal();
        this.processLogger = OSValidator.isUnix() ? new LinuxProcessLogger(this.serverId(), this.logsDirectory, this.terminal, this.configuration()) : new WinProcessLogger(this.serverId(), this.logsDirectory, this.terminal, this.configuration());
        this.graph.processList().forEach(process -> process.processHandler(ProcessManager.createProcessHandler(this, process)));
    }

    @Override
    public void afterStart() {
        this.jmsService = new ConsulJmsService(this.datahubConnector(), this);
    }

    private void extractScripts() {
        try {
            File scripts = this.scriptsDirectory();
            scripts.mkdirs();
            File file = this.rsyncContinuousScript();
            Files.write(file.toPath(), this.getClass().getResourceAsStream("/scripts/rsync-continuous").readAllBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.write(file.toPath(), this.getClass().getResourceAsStream("/scripts/process").readAllBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            file.setExecutable(true);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    @Override
    public void beforeStop() {
        this.isShuttingDown.set(true);
    }

    @Override
    public void afterStop() {
        Logger.info("Shutting down consul");
        if (!OSValidator.isWindows()) {
            return;
        }
        for (Process process : this.graph.processList()) {
            Process.Status status = process.status();
            if (!status.equals((Object)Process.Status.Running)) continue;
            this.processManager.stop(process);
            process.status(status);
        }
    }

    public ConsulTerminal terminal() {
        return this.terminal;
    }

    public DatahubConnector datahubConnector() {
        return this.datahubConnector;
    }

    public ConsulGraph graph() {
        return this.graph;
    }

    public ProcessManager processManager() {
        return this.processManager;
    }

    public void processManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public File scriptsDirectory() {
        return new File(String.valueOf(this.applicationsDirectory) + File.separator + "scripts");
    }

    public File rsyncContinuousScript() {
        return new File(this.scriptsDirectory(), "rsync-continuous");
    }

    public File logsDirectory() {
        return this.logsDirectory;
    }

    public String serverId() {
        return this.serverId;
    }

    public ProcessLogger logHandler() {
        return this.processLogger;
    }

    private void startConsulTerminal() {
        if (this.configuration.datahubUrl() == null) {
            return;
        }
        this.datahubConnector = new DatahubConnector(this.configuration.datahubUrl(), this.configuration.datahubUser(), this.configuration.datahubPassword(), this.configuration.datahubClientid());
        this.datahubConnector.start();
        this.terminal = new ConsulTerminal(this.datahubConnector);
    }

    private String calculateServerId() {
        try {
            return InetAddress.getLocalHost().getHostName().replace(".", "-");
        }
        catch (UnknownHostException e) {
            Logger.error(e.getMessage());
            return "consul-default-server";
        }
    }

    public File localRepository() {
        return this.configuration.localRepositoryDirectory() == null ? new File(System.getProperty("user.home"), ".m2" + File.separator + "repository") : this.configuration.localRepositoryDirectory();
    }

    public AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }
}

