/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.Timeable;
import com.jcabi.aspects.aj.Mnemos;
import com.jcabi.aspects.aj.NamedThreads;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class MethodInterrupter {
    private final transient Set<Call> calls = new ConcurrentSkipListSet<Call>();
    private final transient ScheduledExecutorService interrupter = Executors.newSingleThreadScheduledExecutor(new NamedThreads("timeable", "interrupting of @Timeable annotated methods"));
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodInterrupter ajc$perSingletonInstance;

    public MethodInterrupter() {
        this.interrupter.scheduleWithFixedDelay(new VerboseRunnable(new Runnable(){

            @Override
            public void run() {
                MethodInterrupter.this.interrupt();
            }
        }), 1L, 1L, TimeUnit.SECONDS);
    }

    @Around(value="execution(* * (..)) && @annotation(com.jcabi.aspects.Timeable)")
    public Object wrap(ProceedingJoinPoint point) throws Throwable {
        Object output;
        Call call = new Call(point);
        this.calls.add(call);
        try {
            output = point.proceed();
        }
        finally {
            this.calls.remove(call);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrupt() {
        ScheduledExecutorService scheduledExecutorService = this.interrupter;
        synchronized (scheduledExecutorService) {
            for (Call call : this.calls) {
                if (!call.expired() || !call.interrupted()) continue;
                this.calls.remove(call);
            }
        }
    }

    public static MethodInterrupter aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodInterrupter", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MethodInterrupter.ajc$perSingletonInstance = new MethodInterrupter();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private static final class Call
    implements Comparable<Call> {
        private final transient Thread thread = Thread.currentThread();
        private final transient long start = System.currentTimeMillis();
        private final transient long deadline;
        private final transient ProceedingJoinPoint point;

        public Call(ProceedingJoinPoint pnt) {
            this.point = pnt;
            Method method = ((MethodSignature)MethodSignature.class.cast(pnt.getSignature())).getMethod();
            Timeable annt = method.getAnnotation(Timeable.class);
            this.deadline = this.start + annt.unit().toMillis(annt.limit());
        }

        @Override
        public int compareTo(Call obj) {
            int compare = this.deadline > obj.deadline ? 1 : (this.deadline < obj.deadline ? -1 : 0);
            return compare;
        }

        public boolean expired() {
            return this.deadline < System.currentTimeMillis();
        }

        public boolean interrupted() {
            boolean dead;
            if (this.thread.isAlive()) {
                this.thread.interrupt();
                Method method = ((MethodSignature)MethodSignature.class.cast(this.point.getSignature())).getMethod();
                Logger.warn(method.getDeclaringClass(), "%s: interrupted on %[ms]s timeout (over %[ms]s)", Mnemos.toText(this.point, true, false), System.currentTimeMillis() - this.start, this.deadline - this.start);
                dead = false;
            } else {
                dead = true;
            }
            return dead;
        }
    }
}

