/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.util;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureChecker {
    private Signature sigChecker;
    private final String NOTIFICATION_TYPE = "Notification";
    private final String SUBSCRIBE_TYPE = "SubscriptionConfirmation";
    private final String UNSUBSCRIBE_TYPE = "UnsubscriptionConfirmation";
    private final String TYPE = "Type";
    private final String SUBSCRIBE_URL = "SubscribeURL";
    private final String MESSAGE = "Message";
    private final String TIMESTAMP = "Timestamp";
    private final String SIGNATURE_VERSION = "SignatureVersion";
    private final String SIGNATURE = "Signature";
    private final String MESSAGE_ID = "MessageId";
    private final String SUBJECT = "Subject";
    private final String TOPIC = "TopicArn";
    private final String TOKEN = "Token";

    public boolean verifyMessageSignature(String message, PublicKey publicKey) {
        boolean valid = false;
        Map<String, String> parsed = this.parseJSON(message);
        String version = parsed.get("SignatureVersion");
        if (version.equals("1")) {
            String type = parsed.get("Type");
            String signature = parsed.get("Signature");
            String signed = "";
            if (type.equals("Notification")) {
                signed = this.stringToSign(this.publishMessageValues(parsed));
            } else if (type.equals("SubscriptionConfirmation")) {
                signed = this.stringToSign(this.subscribeMessageValues(parsed));
            } else if (type.equals("UnsubscriptionConfirmation")) {
                signed = this.stringToSign(this.subscribeMessageValues(parsed));
            } else {
                throw new RuntimeException("Cannot process message of type " + type);
            }
            valid = this.verifySignature(signed, signature, publicKey);
        }
        return valid;
    }

    public boolean verifySignature(String message, String signature, PublicKey publicKey) {
        boolean result = false;
        byte[] sigbytes = null;
        try {
            sigbytes = Base64.decodeBase64(signature.getBytes());
            this.sigChecker = Signature.getInstance("SHA1withRSA");
            this.sigChecker.initVerify(publicKey);
            this.sigChecker.update(message.getBytes());
            result = this.sigChecker.verify(sigbytes);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (SignatureException e) {
            // empty catch block
        }
        return result;
    }

    protected String stringToSign(SortedMap<String, String> signables) {
        StringBuilder sb = new StringBuilder();
        for (String k : signables.keySet()) {
            sb.append(k).append("\n");
            sb.append((String)signables.get(k)).append("\n");
        }
        String result = sb.toString();
        return result;
    }

    private Map<String, String> parseJSON(String jsonmessage) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        JsonFactory jf = new JsonFactory();
        try {
            JsonParser parser = jf.createJsonParser(jsonmessage);
            parser.nextToken();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = parser.getCurrentName();
                parser.nextToken();
                String value = parser.getText();
                parsed.put(fieldname, value);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            // empty catch block
        }
        return parsed;
    }

    private TreeMap<String, String> publishMessageValues(Map<String, String> parsedMessage) {
        String[] keys;
        TreeMap<String, String> signables = new TreeMap<String, String>();
        for (String key : keys = new String[]{"Message", "MessageId", "Subject", "Type", "Timestamp", "TopicArn"}) {
            if (!parsedMessage.containsKey(key)) continue;
            signables.put(key, parsedMessage.get(key));
        }
        return signables;
    }

    private TreeMap<String, String> subscribeMessageValues(Map<String, String> parsedMessage) {
        String[] keys;
        TreeMap<String, String> signables = new TreeMap<String, String>();
        for (String key : keys = new String[]{"SubscribeURL", "Message", "MessageId", "Type", "Timestamp", "Token", "TopicArn"}) {
            if (!parsedMessage.containsKey(key)) continue;
            signables.put(key, parsedMessage.get(key));
        }
        return signables;
    }
}

