/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.model;

import io.intino.consul.box.process.ProcessHandler;
import io.intino.consul.model.ConsulGraph;
import io.intino.magritte.framework.Expression;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.loaders.InstantLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.ObjectLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Process
extends Layer
implements Terminal {
    protected Instant creationTime;
    protected String identifier;
    protected Expression<String> shortName;
    protected String workspace;
    protected boolean deployed;
    protected Status status;
    protected ProcessHandler processHandler;
    protected int managementPort;
    protected int debugPort;
    protected int pid;
    protected int ppid;
    protected Expression<String> logFileName;
    protected Expression<String> appDirectoryName;
    protected String runFile;
    protected List<String> jvmParameters = new ArrayList<String>();
    protected Requirements requirements;
    protected List<SyncFileToServer> syncFileToServerList = new ArrayList<SyncFileToServer>();
    protected Artifact artifact;
    protected List<Parameter> parameterList = new ArrayList<Parameter>();

    public Process(Node node) {
        super(node);
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String identifier() {
        return this.identifier;
    }

    public String shortName() {
        return this.shortName.value();
    }

    public String workspace() {
        return this.workspace;
    }

    public boolean deployed() {
        return this.deployed;
    }

    public Status status() {
        return this.status;
    }

    public ProcessHandler processHandler() {
        return this.processHandler;
    }

    public int managementPort() {
        return this.managementPort;
    }

    public int debugPort() {
        return this.debugPort;
    }

    public int pid() {
        return this.pid;
    }

    public int ppid() {
        return this.ppid;
    }

    public String logFileName() {
        return this.logFileName.value();
    }

    public String appDirectoryName() {
        return this.appDirectoryName.value();
    }

    public String runFile() {
        return this.runFile;
    }

    public List<String> jvmParameters() {
        return this.jvmParameters;
    }

    public String jvmParameters(int index) {
        return this.jvmParameters.get(index);
    }

    public List<String> jvmParameters(Predicate<String> predicate) {
        return this.jvmParameters().stream().filter(predicate).collect(Collectors.toList());
    }

    public Process creationTime(Instant value) {
        this.creationTime = value;
        return this;
    }

    public Process identifier(String value) {
        this.identifier = value;
        return this;
    }

    public Process shortName(Expression<String> value) {
        this.shortName = FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    public Process workspace(String value) {
        this.workspace = value;
        return this;
    }

    public Process deployed(boolean value) {
        this.deployed = value;
        return this;
    }

    public Process status(Status value) {
        this.status = value;
        return this;
    }

    public Process processHandler(ProcessHandler value) {
        this.processHandler = value;
        return this;
    }

    public Process managementPort(int value) {
        this.managementPort = value;
        return this;
    }

    public Process debugPort(int value) {
        this.debugPort = value;
        return this;
    }

    public Process pid(int value) {
        this.pid = value;
        return this;
    }

    public Process ppid(int value) {
        this.ppid = value;
        return this;
    }

    public Process logFileName(Expression<String> value) {
        this.logFileName = FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    public Process appDirectoryName(Expression<String> value) {
        this.appDirectoryName = FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    public Process runFile(String value) {
        this.runFile = value;
        return this;
    }

    public Requirements requirements() {
        return this.requirements;
    }

    public List<SyncFileToServer> syncFileToServerList() {
        return Collections.unmodifiableList(this.syncFileToServerList);
    }

    public SyncFileToServer syncFileToServer(int index) {
        return this.syncFileToServerList.get(index);
    }

    public List<SyncFileToServer> syncFileToServerList(Predicate<SyncFileToServer> predicate) {
        return this.syncFileToServerList().stream().filter(predicate).collect(Collectors.toList());
    }

    public SyncFileToServer syncFileToServer(Predicate<SyncFileToServer> predicate) {
        return this.syncFileToServerList().stream().filter(predicate).findFirst().orElse(null);
    }

    public Artifact artifact() {
        return this.artifact;
    }

    public List<Parameter> parameterList() {
        return Collections.unmodifiableList(this.parameterList);
    }

    public Parameter parameter(int index) {
        return this.parameterList.get(index);
    }

    public List<Parameter> parameterList(Predicate<Parameter> predicate) {
        return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Parameter parameter(Predicate<Parameter> predicate) {
        return this.parameterList().stream().filter(predicate).findFirst().orElse(null);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.requirements != null) {
            components.add(this.requirements.core$());
        }
        new ArrayList<SyncFileToServer>(this.syncFileToServerList).forEach(c -> components.add(c.core$()));
        if (this.artifact != null) {
            components.add(this.artifact.core$());
        }
        new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("creationTime", new ArrayList<Instant>(Collections.singletonList(this.creationTime)));
        map.put("identifier", new ArrayList<String>(Collections.singletonList(this.identifier)));
        map.put("shortName", new ArrayList<Expression<String>>(Collections.singletonList(this.shortName)));
        map.put("workspace", new ArrayList<String>(Collections.singletonList(this.workspace)));
        map.put("deployed", new ArrayList<Boolean>(Collections.singletonList(this.deployed)));
        map.put("status", new ArrayList<Status>(Collections.singletonList(this.status)));
        map.put("managementPort", new ArrayList<Integer>(Collections.singletonList(this.managementPort)));
        map.put("debugPort", new ArrayList<Integer>(Collections.singletonList(this.debugPort)));
        map.put("pid", new ArrayList<Integer>(Collections.singletonList(this.pid)));
        map.put("ppid", new ArrayList<Integer>(Collections.singletonList(this.ppid)));
        map.put("logFileName", new ArrayList<Expression<String>>(Collections.singletonList(this.logFileName)));
        map.put("appDirectoryName", new ArrayList<Expression<String>>(Collections.singletonList(this.appDirectoryName)));
        map.put("runFile", new ArrayList<String>(Collections.singletonList(this.runFile)));
        map.put("jvmParameters", this.jvmParameters);
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Process$Requirements")) {
            this.requirements = node.as(Requirements.class);
        }
        if (node.is("Process$SyncFileToServer")) {
            this.syncFileToServerList.add(node.as(SyncFileToServer.class));
        }
        if (node.is("Process$Artifact")) {
            this.artifact = node.as(Artifact.class);
        }
        if (node.is("Process$Parameter")) {
            this.parameterList.add(node.as(Parameter.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Process$Requirements")) {
            this.requirements = null;
        }
        if (node.is("Process$SyncFileToServer")) {
            this.syncFileToServerList.remove(node.as(SyncFileToServer.class));
        }
        if (node.is("Process$Artifact")) {
            this.artifact = null;
        }
        if (node.is("Process$Parameter")) {
            this.parameterList.remove(node.as(Parameter.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("creationTime")) {
            this.creationTime = InstantLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("identifier")) {
            this.identifier = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("shortName")) {
            this.shortName = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        } else if (name.equalsIgnoreCase("workspace")) {
            this.workspace = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("deployed")) {
            this.deployed = BooleanLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("status")) {
            this.status = WordLoader.load(values, Status.class, this).get(0);
        } else if (name.equalsIgnoreCase("processHandler")) {
            this.processHandler = ObjectLoader.load(values, ProcessHandler.class, this).get(0);
        } else if (name.equalsIgnoreCase("managementPort")) {
            this.managementPort = IntegerLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("debugPort")) {
            this.debugPort = IntegerLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("pid")) {
            this.pid = IntegerLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("ppid")) {
            this.ppid = IntegerLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("logFileName")) {
            this.logFileName = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        } else if (name.equalsIgnoreCase("appDirectoryName")) {
            this.appDirectoryName = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        } else if (name.equalsIgnoreCase("runFile")) {
            this.runFile = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("jvmParameters")) {
            this.jvmParameters = StringLoader.load(values, this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("creationTime")) {
            this.creationTime = (Instant)values.get(0);
        } else if (name.equalsIgnoreCase("identifier")) {
            this.identifier = (String)values.get(0);
        } else if (name.equalsIgnoreCase("shortName")) {
            this.shortName = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        } else if (name.equalsIgnoreCase("workspace")) {
            this.workspace = (String)values.get(0);
        } else if (name.equalsIgnoreCase("deployed")) {
            this.deployed = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("status")) {
            this.status = (Status)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("processHandler")) {
            this.processHandler = (ProcessHandler)values.get(0);
        } else if (name.equalsIgnoreCase("managementPort")) {
            this.managementPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("debugPort")) {
            this.debugPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("pid")) {
            this.pid = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("ppid")) {
            this.ppid = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("logFileName")) {
            this.logFileName = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        } else if (name.equalsIgnoreCase("appDirectoryName")) {
            this.appDirectoryName = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        } else if (name.equalsIgnoreCase("runFile")) {
            this.runFile = (String)values.get(0);
        } else if (name.equalsIgnoreCase("jvmParameters")) {
            this.jvmParameters = new ArrayList(values);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public ConsulGraph graph() {
        return this.core$().graph().as(ConsulGraph.class);
    }

    public static class Parameter
    extends Layer
    implements Terminal {
        protected String name;
        protected String value;

        public Parameter(Node node) {
            super(node);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Parameter name(String value) {
            this.name = value;
            return this;
        }

        public Parameter value(String value) {
            this.value = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = StringLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)values.get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            }
        }

        public ConsulGraph graph() {
            return this.core$().graph().as(ConsulGraph.class);
        }
    }

    public static class Artifact
    extends Layer
    implements Terminal {
        protected String groupId;
        protected String artifactId;
        protected String version;
        protected Expression<String> identifier;
        protected String classpathPrefix;
        protected String mainClass;
        protected List<Artifactory> artifactoryList = new ArrayList<Artifactory>();

        public Artifact(Node node) {
            super(node);
        }

        public String groupId() {
            return this.groupId;
        }

        public String artifactId() {
            return this.artifactId;
        }

        public String version() {
            return this.version;
        }

        public String identifier() {
            return this.identifier.value();
        }

        public String classpathPrefix() {
            return this.classpathPrefix;
        }

        public String mainClass() {
            return this.mainClass;
        }

        public Artifact groupId(String value) {
            this.groupId = value;
            return this;
        }

        public Artifact artifactId(String value) {
            this.artifactId = value;
            return this;
        }

        public Artifact version(String value) {
            this.version = value;
            return this;
        }

        public Artifact identifier(Expression<String> value) {
            this.identifier = FunctionLoader.load(value, (Layer)this, Expression.class);
            return this;
        }

        public Artifact classpathPrefix(String value) {
            this.classpathPrefix = value;
            return this;
        }

        public Artifact mainClass(String value) {
            this.mainClass = value;
            return this;
        }

        public List<Artifactory> artifactoryList() {
            return Collections.unmodifiableList(this.artifactoryList);
        }

        public Artifactory artifactory(int index) {
            return this.artifactoryList.get(index);
        }

        public List<Artifactory> artifactoryList(Predicate<Artifactory> predicate) {
            return this.artifactoryList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Artifactory artifactory(Predicate<Artifactory> predicate) {
            return this.artifactoryList().stream().filter(predicate).findFirst().orElse(null);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Artifactory>(this.artifactoryList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("groupId", new ArrayList<String>(Collections.singletonList(this.groupId)));
            map.put("artifactId", new ArrayList<String>(Collections.singletonList(this.artifactId)));
            map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
            map.put("identifier", new ArrayList<Expression<String>>(Collections.singletonList(this.identifier)));
            map.put("classpathPrefix", new ArrayList<String>(Collections.singletonList(this.classpathPrefix)));
            map.put("mainClass", new ArrayList<String>(Collections.singletonList(this.mainClass)));
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Process$Artifact$Artifactory")) {
                this.artifactoryList.add(node.as(Artifactory.class));
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Process$Artifact$Artifactory")) {
                this.artifactoryList.remove(node.as(Artifactory.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("groupId")) {
                this.groupId = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("artifactId")) {
                this.artifactId = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("version")) {
                this.version = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("identifier")) {
                this.identifier = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            } else if (name.equalsIgnoreCase("classpathPrefix")) {
                this.classpathPrefix = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("mainClass")) {
                this.mainClass = StringLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("groupId")) {
                this.groupId = (String)values.get(0);
            } else if (name.equalsIgnoreCase("artifactId")) {
                this.artifactId = (String)values.get(0);
            } else if (name.equalsIgnoreCase("version")) {
                this.version = (String)values.get(0);
            } else if (name.equalsIgnoreCase("identifier")) {
                this.identifier = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            } else if (name.equalsIgnoreCase("classpathPrefix")) {
                this.classpathPrefix = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mainClass")) {
                this.mainClass = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public ConsulGraph graph() {
            return this.core$().graph().as(ConsulGraph.class);
        }

        public static class Artifactory
        extends Layer
        implements Terminal {
            protected String url;
            protected String mavenId;
            protected String user;
            protected String password;
            protected Expression<Boolean> snapshot;

            public Artifactory(Node node) {
                super(node);
            }

            public String url() {
                return this.url;
            }

            public String mavenId() {
                return this.mavenId;
            }

            public String user() {
                return this.user;
            }

            public String password() {
                return this.password;
            }

            public Boolean snapshot() {
                return this.snapshot.value();
            }

            public Artifactory url(String value) {
                this.url = value;
                return this;
            }

            public Artifactory mavenId(String value) {
                this.mavenId = value;
                return this;
            }

            public Artifactory user(String value) {
                this.user = value;
                return this;
            }

            public Artifactory password(String value) {
                this.password = value;
                return this;
            }

            public Artifactory snapshot(Expression<Boolean> value) {
                this.snapshot = FunctionLoader.load(value, (Layer)this, Expression.class);
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                map.put("mavenId", new ArrayList<String>(Collections.singletonList(this.mavenId)));
                map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
                map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
                map.put("snapshot", new ArrayList<Expression<Boolean>>(Collections.singletonList(this.snapshot)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("mavenId")) {
                    this.mavenId = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("user")) {
                    this.user = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("snapshot")) {
                    this.snapshot = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                } else if (name.equalsIgnoreCase("mavenId")) {
                    this.mavenId = (String)values.get(0);
                } else if (name.equalsIgnoreCase("user")) {
                    this.user = (String)values.get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = (String)values.get(0);
                } else if (name.equalsIgnoreCase("snapshot")) {
                    this.snapshot = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
                }
            }

            public ConsulGraph graph() {
                return this.core$().graph().as(ConsulGraph.class);
            }
        }

        public class Clear {
            public void artifactory(Predicate<Artifactory> filter) {
                new ArrayList<Artifactory>(Artifact.this.artifactoryList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Artifactory artifactory(String url, String mavenId, String user, String password) {
                Artifactory newElement = Artifact.this.core$().graph().concept(Artifactory.class).createNode(this.name, Artifact.this.core$()).as(Artifactory.class);
                newElement.core$().set(newElement, "url", Collections.singletonList(url));
                newElement.core$().set(newElement, "mavenId", Collections.singletonList(mavenId));
                newElement.core$().set(newElement, "user", Collections.singletonList(user));
                newElement.core$().set(newElement, "password", Collections.singletonList(password));
                return newElement;
            }
        }
    }

    public static class SyncFileToServer
    extends Layer
    implements Terminal {
        protected String directory;
        protected List<String> targetServers = new ArrayList<String>();

        public SyncFileToServer(Node node) {
            super(node);
        }

        public String directory() {
            return this.directory;
        }

        public List<String> targetServers() {
            return this.targetServers;
        }

        public String targetServers(int index) {
            return this.targetServers.get(index);
        }

        public List<String> targetServers(Predicate<String> predicate) {
            return this.targetServers().stream().filter(predicate).collect(Collectors.toList());
        }

        public SyncFileToServer directory(String value) {
            this.directory = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("directory", new ArrayList<String>(Collections.singletonList(this.directory)));
            map.put("targetServers", this.targetServers);
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("directory")) {
                this.directory = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("targetServers")) {
                this.targetServers = StringLoader.load(values, this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("directory")) {
                this.directory = (String)values.get(0);
            } else if (name.equalsIgnoreCase("targetServers")) {
                this.targetServers = new ArrayList(values);
            }
        }

        public ConsulGraph graph() {
            return this.core$().graph().as(ConsulGraph.class);
        }
    }

    public static class Requirements
    extends Layer
    implements Terminal {
        protected int minMemory;
        protected int maxMemory;

        public Requirements(Node node) {
            super(node);
        }

        public int minMemory() {
            return this.minMemory;
        }

        public int maxMemory() {
            return this.maxMemory;
        }

        public Requirements minMemory(int value) {
            this.minMemory = value;
            return this;
        }

        public Requirements maxMemory(int value) {
            this.maxMemory = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("minMemory", new ArrayList<Integer>(Collections.singletonList(this.minMemory)));
            map.put("maxMemory", new ArrayList<Integer>(Collections.singletonList(this.maxMemory)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("minMemory")) {
                this.minMemory = IntegerLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("maxMemory")) {
                this.maxMemory = IntegerLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("minMemory")) {
                this.minMemory = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("maxMemory")) {
                this.maxMemory = (Integer)values.get(0);
            }
        }

        public ConsulGraph graph() {
            return this.core$().graph().as(ConsulGraph.class);
        }
    }

    public class Clear {
        public void syncFileToServer(Predicate<SyncFileToServer> filter) {
            new ArrayList<SyncFileToServer>(Process.this.syncFileToServerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void parameter(Predicate<Parameter> filter) {
            new ArrayList<Parameter>(Process.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Requirements requirements() {
            Requirements newElement = Process.this.core$().graph().concept(Requirements.class).createNode(this.name, Process.this.core$()).as(Requirements.class);
            return newElement;
        }

        public SyncFileToServer syncFileToServer(String directory, List<String> targetServers) {
            SyncFileToServer newElement = Process.this.core$().graph().concept(SyncFileToServer.class).createNode(this.name, Process.this.core$()).as(SyncFileToServer.class);
            newElement.core$().set(newElement, "directory", Collections.singletonList(directory));
            newElement.core$().set(newElement, "targetServers", targetServers);
            return newElement;
        }

        public Artifact artifact(String groupId, String artifactId, String version) {
            Artifact newElement = Process.this.core$().graph().concept(Artifact.class).createNode(this.name, Process.this.core$()).as(Artifact.class);
            newElement.core$().set(newElement, "groupId", Collections.singletonList(groupId));
            newElement.core$().set(newElement, "artifactId", Collections.singletonList(artifactId));
            newElement.core$().set(newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Parameter parameter(String name, String value) {
            Parameter newElement = Process.this.core$().graph().concept(Parameter.class).createNode(this.name, Process.this.core$()).as(Parameter.class);
            newElement.core$().set(newElement, "name", Collections.singletonList(name));
            newElement.core$().set(newElement, "value", Collections.singletonList(value));
            return newElement;
        }
    }

    public static enum Status {
        Running,
        Stopped,
        Debug;

    }
}

