/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process.win;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.Utils;
import io.intino.consul.box.oshi.OSValidator;
import io.intino.consul.box.process.ProcessHandler;
import io.intino.consul.box.process.ProcessStopListener;
import io.intino.consul.box.process.win.WinProcessLogger;
import io.intino.consul.model.Info;
import io.intino.consul.model.Process;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class WinProcessHandler
implements ProcessHandler {
    public static final int STOP_WAIT_TIME = 10000;
    private static final String ClassPathSeparator = OSValidator.isWindows() ? ";" : ":";
    private final ConsulConfiguration conf;
    private final File appRunDirectory;
    private final File appHomeDirectory;
    private final String scope;
    private final String deployUser;
    private final String deployGroup;
    private final String javaHome;
    private final File tmpDirectory;
    private final io.intino.consul.model.Process process;
    private final ProcessStopListener stopListener;
    private final WinProcessLogger processLogger;
    private transient Process systemProcess;
    private Thread stopListenerThread;

    public WinProcessHandler(io.intino.consul.model.Process process, ConsulConfiguration conf, WinProcessLogger processLogger, ProcessStopListener listener) {
        this.scope = conf.scope();
        this.deployUser = conf.deployUser();
        this.deployGroup = conf.deployGroup();
        this.javaHome = conf.javaHome() != null ? conf.javaHome() : System.getProperty("java.home");
        this.tmpDirectory = conf.tmpDirectory();
        this.conf = conf;
        this.processLogger = processLogger;
        this.process = process;
        this.stopListener = listener;
        this.appHomeDirectory = new File(conf.applicationsWorkspace(), process.appDirectoryName());
        this.appRunDirectory = new File(conf.applicationsDirectory(), process.appDirectoryName());
        this.appRunDirectory.mkdirs();
        this.tmpDirectory.mkdirs();
        Utils.changeOwner(this.tmpDirectory, this.deployUser, this.deployGroup);
    }

    @Override
    public int start() throws Exception {
        Logger.info("Launching " + this.process.identifier() + "...");
        this.systemProcess = this.exec(0);
        this.sleep(1000);
        return this.attach();
    }

    @Override
    public int debug() throws Exception {
        Logger.info("Launching " + this.process.identifier() + " with debug port " + this.process.debugPort());
        this.systemProcess = this.exec(this.process.debugPort());
        this.sleep(1000);
        return this.attach();
    }

    private int attach() {
        this.processLogger.log(this.process, this.systemProcess);
        this.process.ppid((int)this.systemProcess.toHandle().pid());
        List childrenProcesses = this.systemProcess.toHandle().children().collect(Collectors.toList());
        int pid = childrenProcesses.isEmpty() ? this.process.ppid() : (int)((ProcessHandle)childrenProcesses.get(0)).pid();
        Logger.info("Process " + this.process.identifier() + " launched with id: " + pid);
        this.stopListenerThread = new Thread(this::notifyWhenStop);
        this.stopListenerThread.start();
        return pid;
    }

    @Override
    public void stop() {
        if (this.systemProcess == null) {
            return;
        }
        if (this.stopListenerThread != null) {
            this.stopListenerThread.interrupt();
        }
        this.systemProcess.children().forEach(ProcessHandle::destroy);
        this.systemProcess.destroy();
        if (this.systemProcess.isAlive()) {
            try {
                Thread.sleep(this.scope.equals(Info.Scope.EXP.name()) ? 10000L : 5000L);
                this.kill();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
        this.process.status(Process.Status.Stopped);
    }

    public void kill() {
        this.systemProcess.children().forEach(ProcessHandle::destroyForcibly);
        this.systemProcess.toHandle().destroyForcibly();
        this.process.status(Process.Status.Stopped);
    }

    @Override
    public boolean isRunning() {
        return this.systemProcess != null && this.systemProcess.toHandle().isAlive();
    }

    @Override
    public int exitValue() {
        return this.systemProcess != null ? this.systemProcess.exitValue() : -1;
    }

    private Process exec(int debug) throws IOException {
        String mainJar;
        ArrayList<String> commandParams = new ArrayList<String>(this.withDeployUser());
        String javaBin = this.javaHome + File.separator + "bin" + File.separator + "java";
        commandParams.add(javaBin);
        if (this.process.requirements() != null && this.process.requirements().minMemory() > 0) {
            commandParams.add("-Xms" + this.process.requirements().minMemory() + "m");
        }
        if (this.process.requirements() != null && this.process.requirements().maxMemory() > 0) {
            commandParams.add("-Xmx" + this.process.requirements().maxMemory() + "m");
        }
        commandParams.add("-Dfile.encoding=UTF-8");
        commandParams.addAll(this.process.jvmParameters());
        commandParams.add("-Djava.io.tmpdir=" + this.tmpDirectory.getAbsolutePath());
        if (debug > 0) {
            commandParams.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debug);
        }
        if (this.process.managementPort() != 0) {
            this.waitUntilAvailable();
            commandParams.addAll(this.jmxParameters());
        }
        if (!new File(mainJar = new File(this.appRunDirectory, this.process.runFile()).getPath()).exists()) {
            throw new IOException("Main jar not found " + mainJar);
        }
        String mainClass = this.mainClass();
        if (mainClass != null) {
            commandParams.addAll(Arrays.asList("--class-path", mainJar + ClassPathSeparator + this.dependenciesDirectory(this.process.artifact().classpathPrefix()).getCanonicalPath() + "/*"));
            commandParams.add(mainClass);
        } else {
            commandParams.addAll(Arrays.asList("-jar", mainJar));
        }
        commandParams.addAll(this.processParameters());
        if (OSValidator.isWindows()) {
            Logger.info(String.join((CharSequence)" ", commandParams));
        }
        return new ProcessBuilder(commandParams).redirectErrorStream(true).start();
    }

    private List<String> processParameters() {
        String wrapper = OSValidator.isWindows() ? "\"" : "";
        return this.process.parameterList().stream().map(p -> wrapper + p.name() + "=" + this.format(p.value()) + wrapper).collect(Collectors.toList());
    }

    private File dependenciesDirectory(String classpathPrefix) {
        return classpathPrefix.isEmpty() ? this.appRunDirectory : new File(this.appRunDirectory, classpathPrefix);
    }

    private String mainClass() {
        try {
            String mainJar = new File(this.appRunDirectory, this.process.runFile()).getPath();
            JarInputStream jarStream = new JarInputStream(new FileInputStream(mainJar));
            Manifest mf = jarStream.getManifest();
            Attributes attributes = mf.getMainAttributes();
            return attributes.getValue("Main-Class");
        }
        catch (IOException e) {
            return null;
        }
    }

    private void waitUntilAvailable() {
        try {
            while (!this.isAvailable()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isAvailable() {
        boolean result = true;
        try {
            new Socket(InetAddress.getLocalHost(), this.process.managementPort()).close();
            result = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private List<String> withDeployUser() {
        return OSValidator.isWindows() ? Arrays.asList("cmd", "/C") : Arrays.asList("/usr/bin/sudo", "-u", this.deployUser);
    }

    private String format(String value) {
        if (value == null) {
            return "";
        }
        if (value.contains("$HOME")) {
            this.appHomeDirectory.mkdirs();
            Utils.changeOwner(this.appHomeDirectory, this.deployUser, this.deployGroup);
        }
        return value.replace("$HOME", this.conf.applicationsWorkspace());
    }

    private List<String> jmxParameters() {
        return Arrays.asList("-Dcom.sun.management.jmxremote", "--add-opens=java.base/java.nio=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "-Djava.rmi.server.hostname=127.0.0.1", "-Dcom.sun.management.jmxremote.port=" + this.process.managementPort(), "-Dcom.sun.management.jmxremote.rmi.port=" + this.process.managementPort(), "-Dcom.sun.management.jmxremote.local.only=true", "-Dcom.sun.management.jmxremote.authenticate=false", "-Dcom.sun.management.jmxremote.ssl=false", "-XX:+StartAttachListener");
    }

    private void notifyWhenStop() {
        try {
            this.stopListener.onStop(this.process, this.systemProcess.waitFor());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

