/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process.unix;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class SyncHandler {
    private final File appsWorkspace;
    private final String deployUser;
    private final List<Process> rsyncProcesses = new ArrayList<Process>();

    public SyncHandler(File appsWorkspace, String deployUser) {
        this.appsWorkspace = appsWorkspace;
        this.deployUser = deployUser;
    }

    public void sync(String directory, List<String> targetServers) {
        for (String targetServer : targetServers) {
            try {
                Process process = new ProcessBuilder("sudo", "-u", this.deployUser, "bash", "/opt/scripts/rsync-continuous", this.appsWorkspace.getAbsolutePath() + File.separator + directory, targetServer + File.separator + directory).directory(this.appsWorkspace).inheritIO().start();
                Logger.info("Sync process attached with pid: " + process.toHandle().pid());
                this.rsyncProcesses.add(process);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
    }

    public void stop() {
        for (Process p : this.rsyncProcesses) {
            if (p == null) {
                return;
            }
            this.stopChildren(p.children());
            this.destroy(p);
        }
    }

    private void stopChildren(Stream<ProcessHandle> rsyncProcess) {
        rsyncProcess.forEach(p -> {
            this.stopChildren(p.children());
            this.destroy((ProcessHandle)p);
        });
    }

    private void destroy(Process process) {
        process.destroy();
        if (process.isAlive()) {
            try {
                Thread.sleep(10000L);
                this.kill(process);
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
    }

    private void destroy(ProcessHandle process) {
        process.destroy();
        if (process.isAlive()) {
            try {
                Thread.sleep(10000L);
                this.kill(process);
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
    }

    void kill(Process p) {
        p.children().forEach(ProcessHandle::destroyForcibly);
        p.toHandle().destroyForcibly();
    }

    void kill(ProcessHandle p) {
        p.children().forEach(ProcessHandle::destroyForcibly);
        p.destroyForcibly();
    }
}

