/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.Utils;
import io.intino.consul.box.oshi.OSValidator;
import io.intino.consul.box.process.ArtifactResolver;
import io.intino.consul.model.Process;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.sonatype.aether.artifact.Artifact;

public class ProcessDeployer {
    private final Process process;
    private final ConsulConfiguration conf;
    private final ArtifactResolver resolver;
    private final File appRunDirectory;

    public ProcessDeployer(Process process, ConsulConfiguration conf, File localRepository) {
        this.process = process;
        this.conf = conf;
        this.resolver = new ArtifactResolver(process, localRepository);
        this.appRunDirectory = new File(conf.applicationsDirectory(), conf.deployUser() + File.separator + process.appDirectoryName());
    }

    public List<File> deploy() throws Exception {
        List<Artifact> artifacts = this.resolver.failOverResolveArtifacts();
        this.removeRunDirectory();
        List<File> files = this.copyToRunDirectory(artifacts);
        return files;
    }

    private void removeRunDirectory() {
        Utils.removeDirectory(this.appRunDirectory);
    }

    private List<File> copyToRunDirectory(List<Artifact> artifacts) {
        this.appRunDirectory.mkdirs();
        ArrayList<File> files = new ArrayList<File>();
        try {
            files.add(this.copy(artifacts.get(0), ""));
            if (artifacts.size() > 1) {
                for (Artifact artifact : artifacts.subList(1, artifacts.size())) {
                    if (artifact.getFile().equals(artifacts.get(0).getFile())) continue;
                    files.add(this.copy(artifact, this.process.artifact().classpathPrefix()));
                }
            }
            if (OSValidator.isUnix()) {
                this.changePermissionsAndOwnerOfRunDirectory();
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
        return files;
    }

    private void changePermissionsAndOwnerOfRunDirectory() throws IOException {
        try (Stream<Path> paths = Files.walk(this.appRunDirectory.getParentFile().toPath(), new FileVisitOption[0]);){
            paths.forEach(p -> Utils.changeOwner(p.toFile(), this.conf.deployUser(), this.conf.deployGroup()));
        }
    }

    private File copy(Artifact artifact, String classpathPrefix) throws IOException {
        File directory = this.dependenciesDirectory(classpathPrefix);
        directory.mkdir();
        File destination = new File(directory, artifact.getFile().getName());
        Files.copy(artifact.getFile().toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        return destination;
    }

    private File dependenciesDirectory(String classpathPrefix) {
        return classpathPrefix.isEmpty() ? this.appRunDirectory : new File(this.appRunDirectory, classpathPrefix);
    }
}

