/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.LibraryResolver;
import io.intino.consul.model.Process;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class ArtifactResolver {
    private static final String CouldNotFindArtifact = "Could not find artifact";
    private final Process process;
    private final File localRepository;

    public ArtifactResolver(Process process, File localRepository) {
        this.process = process;
        this.localRepository = localRepository;
    }

    List<Artifact> failOverResolveArtifacts() throws Exception {
        List<Artifact> artifacts;
        try {
            artifacts = this.resolveArtifacts();
        }
        catch (DependencyResolutionException e) {
            String error = this.error(e);
            Logger.error(error);
            if (this.resolveFailingDependencyArtifact(this.mavenId(error))) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
            try {
                artifacts = this.resolveArtifacts();
            }
            catch (DependencyResolutionException e2) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
        }
        return artifacts;
    }

    private boolean resolveFailingDependencyArtifact(String mavenId) {
        if (mavenId == null) {
            return false;
        }
        Logger.info("Resolving failed dependency " + mavenId);
        try {
            return this.resolveArtifact(new DefaultArtifact(mavenId)).isEmpty();
        }
        catch (DependencyResolutionException e) {
            return false;
        }
    }

    private String mavenId(String error) {
        if (!error.contains(CouldNotFindArtifact)) {
            return null;
        }
        String substring = error.substring(error.lastIndexOf(CouldNotFindArtifact));
        substring = substring.replace("Could not find artifact ", "");
        return substring.substring(0, substring.indexOf(" ")).trim();
    }

    private List<Artifact> resolveArtifacts() throws DependencyResolutionException {
        Logger.info("Resolving artifacts of " + this.process.identifier());
        this.deleteMainArtifact(this.localRepository);
        DefaultArtifact artifact = new DefaultArtifact(this.process.artifact().identifier());
        return this.resolveArtifact(artifact);
    }

    List<Artifact> resolveArtifact(DefaultArtifact artifact) throws DependencyResolutionException {
        LibraryResolver resolver = new LibraryResolver(this.localRepository, this.process.artifact().artifactoryList());
        ArrayList<Artifact> result = new ArrayList<Artifact>(resolver.resolve(artifact, "compile"));
        result.addAll(resolver.resolve(artifact, "runtime"));
        return result;
    }

    private void deleteMainArtifact(File localRepository) {
        try {
            Process.Artifact artifact = this.process.artifact();
            File directory = new File(localRepository, artifact.groupId().replace(".", File.separator) + File.separator + artifact.artifactId() + File.separator + artifact.version());
            FileUtils.deleteDirectory(directory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String error(DependencyResolutionException e) {
        String stackTrace = ExceptionUtils.getStackTrace(e);
        return Arrays.stream(stackTrace.split("\n")).filter(l -> l.contains(CouldNotFindArtifact) || l.contains("Caused by:")).distinct().collect(Collectors.joining("\n"));
    }
}

