/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.jms.BusConnector;
import io.intino.alexandria.jms.ConnectionListener;
import io.intino.alexandria.jms.JmsProducer;
import io.intino.alexandria.jms.MessageWriter;
import io.intino.alexandria.jms.TopicProducer;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Broker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;

public class DatahubConnector {
    private final String brokerUrl;
    private final String user;
    private final String password;
    private final String clientId;
    private MessageConsumer serviceConsumer;
    private MessageProducer serviceProducer;
    private final Map<String, JmsProducer> producers;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private Connection connection;
    private Session session;

    public DatahubConnector(String brokerUrl, String user, String password, String clientId) {
        this.brokerUrl = brokerUrl;
        this.user = user;
        this.password = password;
        this.clientId = clientId;
        this.producers = new ConcurrentHashMap<String, JmsProducer>();
    }

    public void start() {
        if (this.brokerUrl == null || this.brokerUrl.isEmpty()) {
            Logger.warn("Invalid broker URL. Connection aborted");
            return;
        }
        try {
            while (!this.connect()) {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException | JMSException e) {
            Logger.error(e);
        }
    }

    private boolean connect() throws JMSException {
        if (!Broker.isRunning(this.brokerUrl)) {
            Logger.warn("Broker Unreachable. Connection aborted.");
            return false;
        }
        this.createConnection();
        if (this.connection == null || !((ActiveMQConnection)this.connection).isStarted()) {
            return false;
        }
        this.session = this.createSession();
        if (this.session != null && ((ActiveMQSession)this.session).isRunning()) {
            this.connected.set(true);
        }
        return true;
    }

    public Connection connection() {
        return this.connection;
    }

    public void sendEvent(String path, Event event) {
        if (this.cannotSendMessage()) {
            Logger.error("Message " + event.toMessage().type() + " cannot be sent.");
            return;
        }
        try {
            JmsProducer producer = this.topicProducer(path);
            if (producer == null) {
                return;
            }
            this.sendMessage(producer, DatahubConnector.serialize(event));
        }
        catch (IOException | JMSException e) {
            Logger.error(e);
        }
    }

    private JmsProducer topicProducer(String path) throws JMSException {
        if (((ActiveMQSession)this.session).isClosed()) {
            return null;
        }
        if (!this.producers.containsKey(path)) {
            this.producers.put(path, new TopicProducer(this.session, path));
        }
        return this.producers.get(path);
    }

    public synchronized void createServiceConsumer(String path, MessageListener listener) {
        try {
            Queue destination = this.session.createQueue(path);
            this.serviceConsumer = this.session.createConsumer(destination, null, true);
            this.serviceConsumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    public void serviceResponse(Destination destination, Message message) {
        try {
            if (this.serviceProducer == null) {
                this.serviceProducer = this.session.createProducer(destination);
            }
            this.serviceProducer.send(message);
        }
        catch (JMSException e) {
            try {
                this.serviceProducer.close();
                this.serviceProducer = this.session.createProducer(destination);
                this.serviceProducer.send(message);
            }
            catch (JMSException ex) {
                Logger.error(e);
            }
        }
    }

    private void sendMessage(JmsProducer producer, Message message) {
        try {
            Thread thread = new Thread(() -> producer.produce(message));
            thread.start();
            thread.join(1000L);
            thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean cannotSendMessage() {
        return this.session == null || !this.connected.get();
    }

    private void createConnection() {
        try {
            this.connection = BusConnector.createConnection(this.brokerUrl, this.user, this.password, new ConnectionListener(){

                @Override
                public void transportInterupted() {
                    Logger.warn("Connection with DataHub interrupted");
                    DatahubConnector.this.connected.set(false);
                }

                @Override
                public void transportResumed() {
                    Logger.info("Connection with DataHub established");
                    DatahubConnector.this.connected.set(true);
                }
            });
            if (this.connection != null) {
                if (this.clientId != null && !this.clientId.isEmpty()) {
                    this.connection.setClientID(this.clientId);
                }
                this.connection.start();
            }
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    public void stop() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.session = null;
            this.connection = null;
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private Session createSession() throws JMSException {
        return this.connection.createSession(false, 1);
    }

    private static Message serialize(String payload) throws IOException, JMSException {
        return MessageWriter.write(payload);
    }

    private static Message serialize(Event event) throws IOException, JMSException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        io.intino.alexandria.message.MessageWriter messageWriter = new io.intino.alexandria.message.MessageWriter(os);
        messageWriter.write(event.toMessage());
        messageWriter.close();
        return DatahubConnector.serialize(os.toString());
    }
}

