/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.spark;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.alexandria.http.spark.PushService;
import io.intino.alexandria.http.spark.PushServiceHandler;
import io.intino.alexandria.http.spark.SparkManager;
import java.util.function.Consumer;
import java.util.function.Function;
import spark.Request;
import spark.Response;
import spark.Service;

public class SparkRouter<SM extends SparkManager> {
    private static final int OneDay = 86400000;
    private final String path;
    protected PushService pushService;
    private Function<SparkManager, Boolean> validator = null;
    private Consumer<PushService> pushServiceConsumer = null;
    private Service service;

    public SparkRouter(Service service, String path) {
        this.service = service;
        this.path = path;
    }

    public SparkRouter<SM> before(AlexandriaSpark.ResourceCaller<SM> caller) {
        this.service.before(this.path, (Request rq, Response rs) -> this.before(caller, (SparkManager)this.manager(rq, rs)));
        return this;
    }

    public SparkRouter<SM> get(AlexandriaSpark.ResourceCaller<SM> caller) {
        this.service.get(this.path, (rq, rs) -> this.execute(caller, (SparkManager)this.manager(rq, rs)));
        return this;
    }

    public SparkRouter<SM> post(AlexandriaSpark.ResourceCaller<SM> caller) {
        this.service.post(this.path, (rq, rs) -> this.execute(caller, (SparkManager)this.manager(rq, rs)));
        return this;
    }

    public SparkRouter<SM> put(AlexandriaSpark.ResourceCaller<SM> caller) {
        this.service.put(this.path, (rq, rs) -> this.execute(caller, (SparkManager)this.manager(rq, rs)));
        return this;
    }

    public SparkRouter<SM> delete(AlexandriaSpark.ResourceCaller<SM> caller) {
        this.service.delete(this.path, (rq, rs) -> this.execute(caller, (SparkManager)this.manager(rq, rs)));
        return this;
    }

    public SparkRouter<SM> patch(AlexandriaSpark.ResourceCaller<SM> caller) {
        this.service.patch(this.path, (rq, rs) -> this.execute(caller, (SparkManager)this.manager(rq, rs)));
        return this;
    }

    public SparkRouter<SM> after(AlexandriaSpark.ResourceCaller<SM> caller) {
        this.service.after(this.path, (Request rq, Response rs) -> this.after(caller, (SparkManager)this.manager(rq, rs)));
        return this;
    }

    public void push(PushService service) {
        if (this.pushService != null) {
            return;
        }
        if (this.pushServiceConsumer != null) {
            this.pushServiceConsumer.accept(service);
        }
        PushServiceHandler.inject(service);
        this.service.webSocketIdleTimeoutMillis(86400000);
        this.service.webSocket(this.path, PushServiceHandler.class);
    }

    public void inject(PushService pushService) {
        this.pushService = pushService;
    }

    public void whenRegisterPushService(Consumer<PushService> pushServiceConsumer) {
        this.pushServiceConsumer = pushServiceConsumer;
    }

    public void whenValidate(Function<SparkManager, Boolean> validator) {
        this.validator = validator;
    }

    protected SM manager(Request rq, Response rs) {
        return (SM)new SparkManager<PushService>(this.pushService, rq, rs);
    }

    private boolean validRequest(SparkManager manager) {
        return this.validator != null ? this.validator.apply(manager) : true;
    }

    private String before(AlexandriaSpark.ResourceCaller<SM> caller, SparkManager manager) {
        try {
            caller.call(manager);
        }
        catch (AlexandriaException e) {
            manager.response.status();
            manager.response.body(e.toString());
            this.service.halt(Integer.parseInt(e.code()), e.toString());
        }
        return null;
    }

    private Object execute(AlexandriaSpark.ResourceCaller<SM> caller, SparkManager manager) {
        if (!this.validRequest(manager)) {
            return "FAILURE";
        }
        return this.call(caller, manager);
    }

    private Object after(AlexandriaSpark.ResourceCaller<SM> caller, SparkManager manager) {
        return this.call(caller, manager);
    }

    private Object call(AlexandriaSpark.ResourceCaller<SM> caller, SparkManager manager) {
        try {
            caller.call(manager);
        }
        catch (AlexandriaException e) {
            manager.response.status(Integer.parseInt(e.code()));
            manager.response.body(e.toString());
            this.service.halt(Integer.parseInt(e.code()), e.toString());
        }
        return "OK";
    }
}

