/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aether;

import java.util.Collection;
import java.util.LinkedList;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;

public final class Repository {
    private final transient String identifier;
    private final transient String type;
    private final transient String url;
    private final transient RepositoryPolicy release;
    private final transient RepositoryPolicy snapshot;
    private final transient Proxy proxy;
    private final transient Authentication authentication;
    private final transient Collection<Repository> mirrored;
    private final transient boolean manager;

    public Repository(RemoteRepository remote) {
        this.identifier = remote.getId();
        this.type = remote.getContentType();
        this.url = remote.getUrl();
        this.release = remote.getPolicy(false);
        this.snapshot = remote.getPolicy(true);
        this.proxy = remote.getProxy();
        this.authentication = remote.getAuthentication();
        this.manager = remote.isRepositoryManager();
        this.mirrored = new LinkedList<Repository>();
        for (RemoteRepository mremote : remote.getMirroredRepositories()) {
            this.mirrored.add(new Repository(mremote));
        }
    }

    public RemoteRepository remote() {
        RemoteRepository remote = new RemoteRepository();
        remote.setId(this.identifier);
        remote.setContentType(this.type);
        remote.setUrl(this.url);
        remote.setPolicy(false, this.release);
        remote.setPolicy(true, this.snapshot);
        remote.setProxy(this.proxy);
        remote.setAuthentication(this.authentication);
        remote.setRepositoryManager(this.manager);
        LinkedList<RemoteRepository> remotes = new LinkedList<RemoteRepository>();
        remote.setMirroredRepositories(remotes);
        for (Repository repo : this.mirrored) {
            remotes.add(repo.remote());
        }
        return remote;
    }
}

