/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process.unix;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.ConsulTerminal;
import io.intino.consul.box.Utils;
import io.intino.consul.box.process.ProcessLogger;
import io.intino.consul.model.Process;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class LinuxProcessLogger
implements ProcessLogger {
    public static final String EXITED_TEXT = "Process exited with code: ";
    private final String serverId;
    private final File logsDirectory;
    private final ConsulTerminal terminal;
    private final String deployUser;
    private final String deployGroup;
    private final boolean logsPublish;
    private final Map<Process, Tailer> processes = new HashMap<Process, Tailer>();

    public LinuxProcessLogger(String serverId, File logsDirectory, ConsulTerminal terminal, ConsulConfiguration conf) {
        this.serverId = serverId;
        this.logsDirectory = logsDirectory;
        this.terminal = terminal;
        this.deployUser = conf.deployUser();
        this.deployGroup = conf.deployGroup();
        this.logsPublish = Boolean.parseBoolean(conf.logsPublish());
    }

    void log(Process process) {
        Tailer tailer = new Tailer(process, this.logFile(process), this.onNewLog(process), this.onProcessStop());
        new Thread(tailer).start();
        this.processes.put(process, tailer);
    }

    private OnNewLine onNewLog(Process p) {
        return log -> this.sendMessage(p, log);
    }

    private OnProcessStop onProcessStop() {
        return p -> {
            this.saveInFile(p, this.exitMessage(p));
            this.sendMessage(p, this.exitMessage(p));
            this.release(p);
        };
    }

    private void release(Process process) {
        Tailer tailer = this.processes.get(process);
        if (tailer != null) {
            tailer.stop();
        }
        this.processes.remove(process);
    }

    @Override
    public String lastExecutionLog(Process process) {
        return this.lastExecutionLog(this.logFile(process).toPath());
    }

    void notifyStart(Process p) {
        String message = "Starting process " + p.identifier() + " v." + p.artifact().version() + "...\n";
        this.saveInFile(p, message);
        this.sendMessage(p, message);
    }

    private String lastExecutionLog(Path path) {
        try {
            String text = Files.readString(path, StandardCharsets.UTF_8);
            int contains = text.lastIndexOf(EXITED_TEXT);
            if (contains > 0) {
                String substring = text.substring(contains);
                return substring.substring(substring.indexOf("\n") + 1);
            }
            return text;
        }
        catch (IOException e) {
            Logger.error(e);
            return "";
        }
    }

    private File logFile(Process process) {
        File file = new File(this.logsDirectory, process.logFileName());
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                Utils.changeOwner(file, this.deployUser, this.deployGroup);
                file.setWritable(true, true);
                file.setReadable(true, true);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
        return file;
    }

    private void sendMessage(Process process, String log) {
        ProcessLog processLog = this.newLog(process, log.trim().replaceAll("message:[ ]?\n\t\n\t", "message:"));
        if (this.logsPublish) {
            this.terminal.publish(processLog);
        }
    }

    private void saveInFile(Process p, String log) {
        try {
            Files.write(this.logFile(p).toPath(), (log + "\n\n").getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private ProcessLog newLog(Process process, String log) {
        return new ProcessLog().ts(Instant.now()).serverId(this.serverId).id(process.identifier()).value(log);
    }

    private String exitMessage(Process process) {
        return EXITED_TEXT + process.processHandler().exitValue();
    }

    public static interface OnProcessStop {
        public void onProcessStop(Process var1);
    }

    public static interface OnNewLine {
        public void onNewLog(String var1);
    }

    private static class Tailer
    implements Runnable {
        private final int interval = 500;
        private long lastKnownPosition = 0L;
        private boolean shouldIRun = true;
        private final Process process;
        private final File file;
        private final OnNewLine onNewLine;
        private final OnProcessStop onProcessStop;

        public Tailer(Process process, File file, OnNewLine onNewLine, OnProcessStop onProcessStop) {
            this.process = process;
            this.file = file;
            this.onNewLine = onNewLine;
            this.onProcessStop = onProcessStop;
        }

        public void stop() {
            this.shouldIRun = false;
        }

        @Override
        public void run() {
            try {
                while (this.shouldIRun) {
                    Thread.sleep(500L);
                    if (!this.process.processHandler().isRunning()) {
                        this.onProcessStop.onProcessStop(this.process);
                        return;
                    }
                    long fileLength = this.file.length();
                    if (fileLength <= this.lastKnownPosition) continue;
                    RandomAccessFile accessFile = new RandomAccessFile(this.file, "r");
                    accessFile.seek(this.lastKnownPosition);
                    String log = this.readAll(accessFile);
                    if (!log.isEmpty()) {
                        this.onNewLine.onNewLog(log);
                    }
                    this.lastKnownPosition = accessFile.getFilePointer();
                    accessFile.close();
                }
            }
            catch (Exception e) {
                this.stop();
            }
        }

        private String readAll(RandomAccessFile accessFile) throws IOException {
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = accessFile.readLine()) != null) {
                builder.append(line).append(System.getProperty("line.separator"));
            }
            return builder.toString();
        }
    }
}

