/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.linuxservice;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.Utils;
import io.intino.consul.box.linuxservice.ServiceTemplate;
import io.intino.consul.box.oshi.OSValidator;
import io.intino.consul.model.Process;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class LinuxServiceGenerator {
    private final Process process;
    private final String artifactName;
    private final ConsulConfiguration conf;

    public LinuxServiceGenerator(Process process, ConsulConfiguration conf) {
        this.process = process;
        this.conf = conf;
        this.artifactName = process.artifact().artifactId();
    }

    public void generate(boolean debug) {
        if (!OSValidator.isUnix()) {
            return;
        }
        try {
            FrameBuilder builder = this.frame(debug);
            Path sysconfigFile = this.sysconfigFile();
            Files.writeString(sysconfigFile, (CharSequence)new ServiceTemplate().render(builder.add("sysconfig").toFrame()), new OpenOption[0]);
            Utils.changeOwner(sysconfigFile.toFile(), this.conf.deployUser(), this.conf.deployGroup());
            Files.writeString(this.serviceFile(), (CharSequence)new ServiceTemplate().render(builder.add("service").toFrame()), new OpenOption[0]);
            this.updateSudoers();
            this.updateServices();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void updateServices() {
        try {
            new ProcessBuilder("systemctl", "daemon-reload").inheritIO().start();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void updateSudoers() {
        List<String> servicesAlreadyAdded = this.loadSudoers();
        if (servicesAlreadyAdded.contains(this.artifactName)) {
            return;
        }
        try {
            Files.writeString(this.sudoersFile().toPath(), (CharSequence)this.sudoersTemplate().replace("$artifactName", this.artifactName), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private List<String> loadSudoers() {
        File sudoersFile = this.sudoersFile();
        return this.loadSudoers(sudoersFile);
    }

    private List<String> loadSudoers(File sudoersFile) {
        if (!sudoersFile.exists()) {
            return Collections.emptyList();
        }
        try {
            return this.reduceByService(Files.readAllLines(sudoersFile.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File sudoersFile() {
        return new File("/etc/sudoers.d/" + this.conf.deployUser());
    }

    private List<String> reduceByService(List<String> lines) {
        return lines.stream().filter(l -> !l.trim().isEmpty()).map(this::findService).distinct().collect(Collectors.toList());
    }

    private String findService(String l) {
        String[] words = l.split(" ");
        return words[words.length - 1].trim();
    }

    private Path sysconfigFile() {
        return new File("/etc/sysconfig/", this.artifactName.toLowerCase()).toPath();
    }

    private Path serviceFile() {
        return new File("/etc/systemd/system/", this.artifactName.toLowerCase() + ".service").toPath();
    }

    private FrameBuilder frame(boolean debug) {
        FrameBuilder builder = new FrameBuilder().add("artifact", this.artifactName).add("user", this.conf.deployUser()).add("home", this.conf.applicationsWorkspace()).add("tmp", this.conf.tmpDirectory().getAbsolutePath()).add("java", this.conf.javaHome() != null ? this.conf.javaHome() : System.getProperty("java.home")).add("managementPort", this.process.managementPort()).add("parameter", this.parameters()).add("restart", "Restart");
        if (debug) {
            builder.add("debug", this.process.debugPort());
        }
        if (this.process.runFile() != null) {
            builder.add("artifactFile", new File(this.process.runFile()).getName());
        }
        if (this.process.artifact().mainClass() != null) {
            builder.add("withClassPath").add("mainClass", this.process.artifact().mainClass());
        }
        if (this.process.artifact().classpathPrefix() != null) {
            builder.add("dependencies", this.directoryFrame());
        }
        if (this.process.requirements() != null && this.process.requirements().minMemory() > 0) {
            builder.add("minMemory", this.process.requirements().minMemory());
        }
        if (this.process.requirements() != null && this.process.requirements().maxMemory() > 0) {
            builder.add("maxMemory", this.process.requirements().maxMemory());
        }
        return builder;
    }

    private Frame directoryFrame() {
        return new FrameBuilder("dependencies").add("user", this.conf.deployUser()).add("artifact", this.process.artifact().artifactId()).add("directory", this.process.artifact().classpathPrefix()).toFrame();
    }

    private Frame[] parameters() {
        return (Frame[])this.process.parameterList().stream().map(p -> new FrameBuilder("parameter").add("name", p.name()).add("value", p.value()).toFrame()).toArray(Frame[]::new);
    }

    private String sudoersTemplate() {
        return "intino ALL= (root) NOPASSWD: /bin/systemctl start $artifactName\nintino ALL= (root) NOPASSWD: /bin/systemctl stop $artifactName\nintino ALL= (root) NOPASSWD: /bin/systemctl restart $artifactName\nintino ALL= (root) NOPASSWD: /bin/systemctl status $artifactName\n\n";
    }
}

