/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.Context;
import io.intino.cesar.datahub.events.consul.server.ServerInfo;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.oshi.ServerInfoProvider;
import io.intino.consul.model.Info;
import java.time.Instant;

public class CheckServerInfoChangesAction {
    public ConsulBox box;
    public Context context = new Context();

    public void execute() {
        ServerInfo serverInfo = this.serverInfo();
        if (!this.hasChanges(serverInfo)) {
            return;
        }
        if (this.box.terminal() != null) {
            this.box.terminal().publish(serverInfo);
        }
        if (this.box.graph().info() == null) {
            this.box.graph().create().info(this.box.serverId(), serverInfo.diskSize(), serverInfo.memorySize().longValue(), serverInfo.ip(), Info.Scope.valueOf(this.box.configuration().scope().toUpperCase()));
        } else {
            this.box.graph().info().diskSize(serverInfo.diskSize()).memorySize(serverInfo.memorySize().longValue()).ip(serverInfo.ip());
        }
    }

    private boolean hasChanges(ServerInfo serverInfo) {
        Info info = this.box.graph().info();
        return info == null || info.diskSize() != serverInfo.diskSize().longValue() || info.memorySize() != (double)serverInfo.memorySize().longValue() || !info.ip().equals(serverInfo.ip());
    }

    private ServerInfo serverInfo() {
        ServerInfoProvider provider = new ServerInfoProvider();
        return (ServerInfo)new ServerInfo().id(this.box.serverId()).ts(Instant.now()).ip(provider.ip()).os(System.getProperty("os.name")).diskSize(provider.hddCapacityInMb(this.box.configuration().applicationsWorkspace())).memorySize(provider.memoryCapacityInMb());
    }
}

