/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.Utils;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.stores.InMemoryFileStore;
import io.intino.magritte.io.Node;
import io.intino.magritte.io.Stash;
import io.intino.magritte.io.Variable;
import java.io.File;
import java.util.List;
import org.apache.log4j.Level;

public class Main {
    public static void main(String[] args) {
        Logger.info("Starting Consul v." + Utils.currentVersion());
        ConsulConfiguration configuration = new ConsulConfiguration(args);
        ConsulBox box = (ConsulBox)new ConsulBox(configuration).put(Main.loadGraph(configuration)).start();
        io.intino.alexandria.logger4j.Logger.setLevel(Level.ERROR);
        if (box.terminal() == null) {
            Logger.error("Terminal couldn't init");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(box::stop));
    }

    private static Graph loadGraph(ConsulConfiguration configuration) {
        return new Graph(Main.store(configuration)).loadStashes("Consul");
    }

    private static Store store(ConsulConfiguration configuration) {
        return new InMemoryFileStore(new File(configuration.home(), "store")){

            @Override
            public void writeStash(Stash stash, String path) {
                stash.language = stash.language == null || stash.language.isEmpty() ? "Consul" : stash.language;
                super.writeStash(stash, path);
            }

            @Override
            public Stash stashFrom(String path) {
                Stash stash = super.stashFrom(path);
                if (stash == null || stash.nodes.isEmpty()) {
                    return stash;
                }
                Main.updateVariables(stash.nodes);
                return stash;
            }
        };
    }

    private static void updateVariables(List<Node> nodes) {
        nodes.forEach(Main::updateNodeVariables);
    }

    private static void updateNodeVariables(Node n) {
        n.variables.stream().filter(v -> v instanceof Variable.Function).forEach(v -> {
            List<?> values = v.values;
            values.set(0, Main.newFunctionPackage(v));
        });
        Main.updateVariables(n.nodes);
    }

    private static String newFunctionPackage(Variable v) {
        return v.values.get(0).toString().replace("io.intino.consul.graph", "io.intino.consul.model");
    }
}

