/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.lifecycle.Lifecycle;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DefaultLifecycles.class)
public class DefaultLifecycles {
    public static final String[] STANDARD_LIFECYCLES = new String[]{"default", "clean", "site"};
    @Requirement(role=Lifecycle.class)
    private Map<String, Lifecycle> lifecycles;
    @Requirement
    private Logger logger;

    public DefaultLifecycles() {
    }

    public DefaultLifecycles(Map<String, Lifecycle> lifecycles, Logger logger2) {
        this.lifecycles = new LinkedHashMap<String, Lifecycle>();
        this.logger = logger2;
        this.lifecycles = lifecycles;
    }

    public Lifecycle get(String key) {
        return this.getPhaseToLifecycleMap().get(key);
    }

    public Map<String, Lifecycle> getPhaseToLifecycleMap() {
        HashMap<String, Lifecycle> phaseToLifecycleMap = new HashMap<String, Lifecycle>();
        for (Lifecycle lifecycle : this.getLifeCycles()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Lifecycle " + lifecycle);
            }
            for (String phase : lifecycle.getPhases()) {
                if (!phaseToLifecycleMap.containsKey(phase)) {
                    phaseToLifecycleMap.put(phase, lifecycle);
                    continue;
                }
                Lifecycle original = phaseToLifecycleMap.get(phase);
                this.logger.warn("Duplicated lifecycle phase " + phase + ". Defined in " + original.getId() + " but also in " + lifecycle.getId());
            }
        }
        return phaseToLifecycleMap;
    }

    public List<Lifecycle> getLifeCycles() {
        LinkedHashMap<String, Lifecycle> lifecycles = new LinkedHashMap<String, Lifecycle>(this.lifecycles);
        LinkedHashSet<String> lifecycleNames = new LinkedHashSet<String>(Arrays.asList(STANDARD_LIFECYCLES));
        lifecycleNames.addAll(lifecycles.keySet());
        ArrayList<Lifecycle> result = new ArrayList<Lifecycle>();
        for (String name : lifecycleNames) {
            result.add((Lifecycle)lifecycles.get(name));
        }
        return result;
    }

    public String getLifecyclePhaseList() {
        LinkedHashSet<String> phases = new LinkedHashSet<String>();
        for (Lifecycle lifecycle : this.lifecycles.values()) {
            phases.addAll(lifecycle.getPhases());
        }
        return StringUtils.join(phases.iterator(), ", ");
    }
}

