/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework;

import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.NativeCode;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.tags.Terminal;
import io.intino.magritte.framework.types.DateX;
import io.intino.magritte.io.Helper;
import io.intino.magritte.io.Variable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class StashWriter {
    private final Graph model;
    private final String stash;
    private final List<Node> nodes;

    private StashWriter(Graph model, String stash, List<Node> nodes) {
        this.model = model;
        this.stash = stash;
        this.nodes = nodes;
    }

    static void write(Graph model, String stash, List<Node> nodes) {
        new StashWriter(model, stash, nodes).write();
    }

    private void write() {
        this.model.store.writeStash(Helper.newStash(this.language(), this.nodes(this.nodes)), this.stash);
    }

    private String language() {
        ArrayList<String> languages = new ArrayList<String>(this.model.languages);
        return languages.isEmpty() ? null : (String)languages.get(0);
    }

    private List<io.intino.magritte.io.Node> nodes(List<Node> nodes) {
        return nodes.stream().map(this::node).collect(Collectors.toList());
    }

    private io.intino.magritte.io.Node node(Node node) {
        return Helper.newNode(node.id, this.layersOf(node), this.variablesOf(node.variables()), this.nodes(node.componentList()));
    }

    private List<String> layersOf(Node node) {
        return node.layers.stream().filter(l -> l instanceof Terminal).map(this::conceptIdOf).collect(Collectors.toList());
    }

    private List<? extends Variable> variablesOf(Map<String, List<?>> variables) {
        variables.entrySet().forEach(e -> e.setValue(new ArrayList((Collection)e.getValue())));
        return variables.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty() && ((List)e.getValue()).get(0) != null).map(this::variableOf).collect(Collectors.toList());
    }

    private Variable variableOf(Map.Entry<String, List<?>> variable) {
        Object value = variable.getValue().get(0);
        if (value instanceof Integer) {
            return Helper.newInteger(variable.getKey(), variable.getValue());
        }
        if (value instanceof Long) {
            return Helper.newLong(variable.getKey(), variable.getValue());
        }
        if (value instanceof Double) {
            return Helper.newDouble(variable.getKey(), variable.getValue());
        }
        if (value instanceof Boolean) {
            return Helper.newBoolean(variable.getKey(), variable.getValue());
        }
        if (value instanceof String) {
            return Helper.newString(variable.getKey(), variable.getValue());
        }
        if (value instanceof URL) {
            return Helper.newResource(variable.getKey(), this.resourceOf(variable.getValue()));
        }
        if (value instanceof Layer) {
            return Helper.newReference(variable.getKey(), this.refsOfLayers(variable.getValue()));
        }
        if (value instanceof Enum) {
            return Helper.newWord(variable.getKey(), this.words(variable.getValue()));
        }
        if (value instanceof NativeCode) {
            return Helper.newFunction(variable.getKey(), this.classesOf(variable.getValue()));
        }
        if (value instanceof Instant) {
            return Helper.newInstant(variable.getKey(), this.instantOf(variable.getValue()));
        }
        if (value instanceof DateX) {
            return Helper.newDate(variable.getKey(), this.dateOf(variable.getValue()));
        }
        if (value instanceof LocalTime) {
            return Helper.newTime(variable.getKey(), this.timeOf(variable.getValue()));
        }
        if (value instanceof Concept) {
            return Helper.newConcept(variable.getKey(), this.conceptOf(variable.getValue()));
        }
        return Helper.newObject(variable.getKey(), this.objectOf(variable.getValue()));
    }

    private List<String> conceptOf(List<?> values) {
        return values.stream().map(v -> ((Concept)v).id()).collect(Collectors.toList());
    }

    private List<String> resourceOf(List<?> values) {
        return values.stream().map(v -> this.model.store.relativePathOf((URL)v)).collect(Collectors.toList());
    }

    private List<String> timeOf(List<?> values) {
        return values.stream().map(v -> ((LocalTime)v).format(DateTimeFormatter.ofPattern("HH:mm:ss"))).collect(Collectors.toList());
    }

    private List<Long> instantOf(List<?> values) {
        return values.stream().map(i -> ((Instant)i).toEpochMilli()).collect(Collectors.toList());
    }

    private List<String> dateOf(List<?> values) {
        return values.stream().map(v -> ((LocalDateTime)v).format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"))).collect(Collectors.toList());
    }

    private List<Object> objectOf(List<?> values) {
        return values.stream().map(v -> v).collect(Collectors.toList());
    }

    private List<String> classesOf(List<?> values) {
        return values.stream().map(v -> v.getClass().getCanonicalName()).collect(Collectors.toList());
    }

    private List<String> refsOfLayers(List<?> layers) {
        return layers.stream().map(l -> ((Layer)l).core$().id()).collect(Collectors.toList());
    }

    private List<String> words(List<?> values) {
        return values.stream().map(Object::toString).collect(Collectors.toList());
    }

    private String conceptIdOf(Layer layer) {
        return this.model.layerFactory.names(layer.getClass()).get(0);
    }
}

