/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework;

import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphHelper;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.LayerFactory;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.NodeLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.logging.Logger;

class GraphCloner {
    GraphCloner() {
    }

    static Graph doClone(Graph graph, Graph clone) {
        clone.loaders = new ArrayList<NodeLoader>(graph.loaders);
        clone.languages = new LinkedHashSet<String>(graph.languages);
        clone.concepts = new HashMap<String, Concept>(graph.concepts);
        clone.nodes = new HashMap<String, Node>(graph.nodes);
        clone.layerFactory = new LayerFactory(graph.layerFactory);
        clone.openedStashes = new HashSet<String>(graph.openedStashes);
        graph.model.componentList().forEach(clone.model::add);
        graph.wrappers.values().forEach(w -> GraphCloner.cloneWrapper(clone, w));
        return clone;
    }

    private static void cloneWrapper(Graph clone, GraphWrapper w) {
        Class<?> aClass = w.getClass();
        try {
            clone.wrappers.put((Class<? extends GraphWrapper>)aClass, (GraphWrapper)GraphHelper.create(aClass, clone, w));
        }
        catch (Throwable e) {
            Logger.getGlobal().info("Copy constructor on " + aClass.getSimpleName() + " not found. To improve performance when cloning, add constructor \"" + aClass.getSimpleName() + "(Graph graph, " + aClass.getSimpleName() + " wrapper)\" calling super (Builder 2.0.8+)");
            clone.wrappers.put((Class<? extends GraphWrapper>)aClass, (GraphWrapper)GraphHelper.create(aClass, clone));
        }
    }
}

