/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.terminal.Connector;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.PostProcessParameterAction;

public class ParameterRequest
implements Connector.MessageConsumer {
    private final ConsulBox box;

    public ParameterRequest(ConsulBox box) {
        this.box = box;
    }

    @Override
    public void accept(String request, String callback) {
        try {
            Message message = new MessageReader(request).next();
            this.box.datahubConnector().sendMessage(callback, this.actionFor(message.get("processId").asString(), message.get("name").asString(), message.get("value").asString()).execute().toString());
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    private PostProcessParameterAction actionFor(String processId, String name, String value) {
        PostProcessParameterAction action = new PostProcessParameterAction();
        action.box = this.box;
        action.process = processId;
        action.name = name;
        action.value = value;
        return action;
    }
}

