/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.rest.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkPushService;
import io.intino.alexandria.rest.RequestAdapter;
import io.intino.alexandria.rest.Resource;
import io.intino.alexandria.rest.ResponseAdapter;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.PostProcessStatusAction;

public class PostProcessStatusResource
implements Resource {
    private ConsulBox box;
    private SparkManager<SparkPushService> manager;

    public PostProcessStatusResource(ConsulBox box, SparkManager manager) {
        this.box = box;
        this.manager = manager;
    }

    @Override
    public void execute() throws AlexandriaException {
        this.write(this.fill(new PostProcessStatusAction()).execute());
    }

    private PostProcessStatusAction fill(PostProcessStatusAction action) throws AlexandriaException {
        action.box = this.box;
        action.context = this.context();
        try {
            action.process = RequestAdapter.adapt(this.manager.fromPath("process"), String.class);
            action.operation = RequestAdapter.adapt(this.manager.fromQuery("operation"), String.class);
            action.debugging = RequestAdapter.adapt(this.manager.fromQueryOrDefault("debugging", "false"), Boolean.class);
        }
        catch (Throwable e) {
            action.onMalformedRequest(e);
        }
        return action;
    }

    private void write(Integer object) {
        this.manager.write(ResponseAdapter.adapt(object));
    }

    private SparkContext context() {
        SparkContext context = new SparkContext(this.manager);
        context.put("ip", this.manager.ip());
        return context;
    }
}

