/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.StartProcessAction;
import io.intino.consul.box.process.ProcessStopListener;
import io.intino.consul.graph.Process;

public class RestartProcessOnStop
implements ProcessStopListener {
    private final ConsulBox box;

    public RestartProcessOnStop(ConsulBox box) {
        this.box = box;
    }

    @Override
    public void onStop(Process process, int exitCode) {
        try {
            if (exitCode == 0) {
                return;
            }
            Thread.sleep(5000L);
            if (!this.box.isShuttingDown()) {
                new StartProcessAction(this.box, process.identifier()).execute();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

