/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.process;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.LibraryResolver;
import io.intino.consul.box.Utils;
import io.intino.consul.box.oshi.OSValidator;
import io.intino.consul.box.process.ProcessLogger;
import io.intino.consul.box.process.ProcessStopListener;
import io.intino.consul.box.process.SyncHandler;
import io.intino.consul.graph.Info;
import io.intino.consul.graph.Process;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class ProcessHandler {
    public static final String CouldNotFindArtifact = "Could not find artifact";
    public static final String CouldNotTransferArtifact = "Could not transfer artifact";
    private static final String ClassPathSeparator = OSValidator.isWindows() ? ";" : ":";
    public static final int STOP_WAIT_TIME = 10000;
    private final File appRunDirectory;
    private final File appHomeDirectory;
    private final String scope;
    private final String deployUser;
    private final String deployGroup;
    private final String javaHome;
    private final File appsHome;
    private final File tmpDirectory;
    private final File localRepository;
    private final io.intino.consul.graph.Process process;
    private final ProcessStopListener listener;
    private final ProcessLogger processLogger;
    private final transient SyncHandler syncHandler;
    private transient Process systemProcess;
    private Thread stopNotifier;

    public ProcessHandler(io.intino.consul.graph.Process process, ConsulConfiguration configuration, File appsHome, File applicationsDirectory, File localRepository, ProcessLogger processLogger, ProcessStopListener listener) {
        this.scope = configuration.scope();
        this.deployUser = configuration.deployUser();
        this.deployGroup = configuration.deployGroup();
        this.javaHome = configuration.javaHome() != null ? configuration.javaHome() : System.getProperty("java.home");
        this.tmpDirectory = new File(configuration.tmpDirectory());
        this.appsHome = appsHome;
        this.localRepository = localRepository;
        this.processLogger = processLogger;
        this.process = process;
        this.listener = listener;
        this.appHomeDirectory = new File(appsHome, process.appDirectoryName());
        this.appRunDirectory = new File(applicationsDirectory, process.appDirectoryName());
        this.appRunDirectory.mkdirs();
        this.tmpDirectory.mkdirs();
        this.syncHandler = new SyncHandler(appsHome, this.deployUser);
        Utils.changeOwner(this.tmpDirectory, this.deployUser, this.deployGroup);
    }

    void create() throws Exception {
        List<Artifact> artifacts;
        try {
            artifacts = this.resolveArtifacts();
        }
        catch (DependencyResolutionException e) {
            String error = this.error(e);
            Logger.error(error);
            if (this.resolveFailingDependencyArtifact(this.mavenId(error))) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
            try {
                artifacts = this.resolveArtifacts();
            }
            catch (DependencyResolutionException e2) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
        }
        this.removeRunDirectory();
        this.copyToRunDirectory(artifacts);
        this.process.runFile(artifacts.get(0).getFile().getName()).save$();
    }

    void start(int debugPort) throws Exception {
        if (this.process.runFile() == null || !new File(this.appRunDirectory, this.process.runFile()).exists()) {
            this.create();
        }
        Logger.info("Launching " + this.process.identifier() + (String)(debugPort > 0 ? " with debug port " + debugPort : "") + "...");
        this.systemProcess = this.exec(debugPort);
        this.sleep(1000);
        this.processLogger.log(this.process, this.systemProcess);
        this.process.ppid((int)this.systemProcess.toHandle().pid());
        List childrenProcesses = this.systemProcess.toHandle().children().collect(Collectors.toList());
        this.process.pid(childrenProcesses.isEmpty() ? this.process.ppid() : (int)((ProcessHandle)childrenProcesses.get(0)).pid());
        this.process.status(debugPort > 0 ? Process.Status.Debug : Process.Status.Running);
        this.process.debugPort(debugPort);
        this.process.save$();
        Logger.info("Process " + this.process.identifier() + " launched with id: " + this.process.pid());
        if (this.listener != null && this.scope.equals(Info.Scope.EXP.name())) {
            this.stopNotifier = new Thread(this::notifyWhenStop);
            this.stopNotifier.start();
        }
        for (Process.SyncFileToServer syncFileToServer : this.process.syncFileToServerList()) {
            this.syncHandler.sync(syncFileToServer.directory(), syncFileToServer.targetServers());
        }
    }

    void stop() {
        if (this.systemProcess == null) {
            return;
        }
        if (this.stopNotifier != null) {
            this.stopNotifier.interrupt();
        }
        this.systemProcess.children().forEach(ProcessHandle::destroy);
        this.systemProcess.destroy();
        if (this.systemProcess.isAlive()) {
            try {
                Thread.sleep(this.scope.equals(Info.Scope.EXP.name()) ? 10000L : 5000L);
                this.kill();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
        if (this.syncHandler != null) {
            this.syncHandler.stop();
        }
        this.process.status(Process.Status.Stopped);
    }

    void kill() {
        this.systemProcess.children().forEach(ProcessHandle::destroyForcibly);
        this.systemProcess.toHandle().destroyForcibly();
        this.process.status(Process.Status.Stopped);
    }

    boolean isRunning() {
        return this.systemProcess != null && this.systemProcess.toHandle().isAlive();
    }

    int exitValue() {
        return this.systemProcess != null ? this.systemProcess.exitValue() : -1;
    }

    void removeRunDirectory() {
        Utils.removeDirectory(this.appRunDirectory);
    }

    void removeAppHomeDirectory() {
        this.appHomeDirectory.renameTo(new File(this.appHomeDirectory.getParentFile(), this.appHomeDirectory.getName() + "_" + System.currentTimeMillis() / 1000L));
    }

    private boolean resolveFailingDependencyArtifact(String mavenId) {
        if (mavenId == null) {
            return false;
        }
        Logger.info("Resolving failed dependency " + mavenId);
        try {
            return !this.resolveArtifact(new DefaultArtifact(mavenId)).isEmpty();
        }
        catch (DependencyResolutionException e) {
            return false;
        }
    }

    private String mavenId(String error) {
        if (!error.contains(CouldNotFindArtifact)) {
            return null;
        }
        String substring = error.substring(error.lastIndexOf(CouldNotFindArtifact));
        substring = substring.replace("Could not find artifact ", "");
        return substring.substring(0, substring.indexOf(" ")).trim();
    }

    private void copyToRunDirectory(List<Artifact> artifacts) {
        try {
            this.copy(artifacts.get(0), "");
            if (artifacts.size() > 1) {
                for (Artifact artifact : artifacts.subList(1, artifacts.size())) {
                    if (artifact.getFile().equals(artifacts.get(0).getFile())) continue;
                    this.copy(artifact, this.process.artifact().classpathPrefix());
                }
            }
            if (OSValidator.isUnix()) {
                this.changePermissionsAndOwnerOfRunDirectory();
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void changePermissionsAndOwnerOfRunDirectory() throws IOException {
        try (Stream<Path> paths = Files.walk(this.appRunDirectory.toPath(), new FileVisitOption[0]);){
            paths.forEach(p -> Utils.changeOwner(p.toFile(), this.deployUser, this.deployGroup));
        }
    }

    private void copy(Artifact artifact, String classpathPrefix) throws IOException {
        File directory = this.dependenciesDirectory(classpathPrefix);
        directory.mkdir();
        Files.copy(artifact.getFile().toPath(), new File(directory, artifact.getFile().getName()).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    private File dependenciesDirectory(String classpathPrefix) {
        return classpathPrefix.isEmpty() ? this.appRunDirectory : new File(this.appRunDirectory, classpathPrefix);
    }

    private Process exec(int debug) throws IOException {
        String mainJar;
        ArrayList<String> commandParams = new ArrayList<String>(this.withDeployUser());
        String javaBin = this.javaHome + File.separator + "bin" + File.separator + "java";
        commandParams.add(javaBin);
        if (this.process.requirements() != null && this.process.requirements().minMemory() > 0) {
            commandParams.add("-Xms" + this.process.requirements().minMemory() + "m");
        }
        if (this.process.requirements() != null && this.process.requirements().maxMemory() > 0) {
            commandParams.add("-Xmx" + this.process.requirements().maxMemory() + "m");
        }
        commandParams.add("-Dfile.encoding=UTF-8");
        commandParams.addAll(this.process.jvmParameters());
        commandParams.add("-Djava.io.tmpdir=" + this.tmpDirectory.getAbsolutePath());
        if (debug > 0) {
            commandParams.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debug);
        }
        if (this.process.managementPort() != 0) {
            this.waitUntilAvailable();
            commandParams.addAll(this.jmxParameters());
        }
        if (!new File(mainJar = new File(this.appRunDirectory, this.process.runFile()).getPath()).exists()) {
            throw new IOException("Main jar not found " + mainJar);
        }
        String mainClass = this.mainClass();
        if (mainClass != null) {
            commandParams.addAll(Arrays.asList("--class-path", mainJar + ClassPathSeparator + this.dependenciesDirectory(this.process.artifact().classpathPrefix()).getCanonicalPath() + "/*"));
            commandParams.add(mainClass);
        } else {
            commandParams.addAll(Arrays.asList("-jar", mainJar));
        }
        commandParams.addAll(this.processParameters());
        if (OSValidator.isWindows()) {
            Logger.info(String.join((CharSequence)" ", commandParams));
        }
        return new ProcessBuilder(commandParams).redirectErrorStream(true).start();
    }

    private List<String> processParameters() {
        String wrapper = OSValidator.isWindows() ? "\"" : "";
        return this.process.parameterList().stream().map(p -> wrapper + p.name() + "=" + this.format(p.value()) + wrapper).collect(Collectors.toList());
    }

    private String mainClass() {
        try {
            String mainJar = new File(this.appRunDirectory, this.process.runFile()).getPath();
            JarInputStream jarStream = new JarInputStream(new FileInputStream(mainJar));
            Manifest mf = jarStream.getManifest();
            Attributes attributes = mf.getMainAttributes();
            return attributes.getValue("Main-Class");
        }
        catch (IOException e) {
            return null;
        }
    }

    private void waitUntilAvailable() {
        try {
            while (!this.isAvailable()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isAvailable() {
        boolean result = true;
        try {
            new Socket(InetAddress.getLocalHost(), this.process.managementPort()).close();
            result = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private List<String> withDeployUser() {
        return OSValidator.isWindows() ? Arrays.asList("cmd", "/C") : Arrays.asList("/usr/bin/sudo", "-u", this.deployUser);
    }

    private String error(DependencyResolutionException e) {
        String stackTrace = ExceptionUtils.getStackTrace(e);
        return Arrays.stream(stackTrace.split("\n")).filter(l -> l.contains(CouldNotFindArtifact) || l.contains("Caused by:")).distinct().collect(Collectors.joining("\n"));
    }

    private String format(String value) {
        if (value == null) {
            return "";
        }
        if (value.contains("$HOME")) {
            this.appHomeDirectory.mkdirs();
            Utils.changeOwner(this.appHomeDirectory, this.deployUser, this.deployGroup);
        }
        return value.replace("$HOME", this.appsHome.getAbsolutePath());
    }

    private List<Artifact> resolveArtifacts() throws DependencyResolutionException {
        Logger.info("Resolving artifacts of " + this.process.identifier());
        this.deleteMainArtifact(this.localRepository);
        DefaultArtifact artifact = new DefaultArtifact(this.process.artifact().identifier());
        return this.resolveArtifact(artifact);
    }

    private List<Artifact> resolveArtifact(DefaultArtifact artifact) throws DependencyResolutionException {
        LibraryResolver resolver = new LibraryResolver(this.localRepository, this.process.artifact().artifactoryList());
        ArrayList<Artifact> result = new ArrayList<Artifact>(resolver.resolve(artifact, "compile"));
        result.addAll(resolver.resolve(artifact, "runtime"));
        return result;
    }

    private void deleteMainArtifact(File localRepository) {
        try {
            Process.Artifact artifact = this.process.artifact();
            File directory = new File(localRepository, artifact.groupId().replace(".", File.separator) + File.separator + artifact.artifactId() + File.separator + artifact.version());
            FileUtils.deleteDirectory(directory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<String> jmxParameters() {
        return Arrays.asList("-Dcom.sun.management.jmxremote", "--add-opens=java.base/java.nio=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "-Djava.rmi.server.hostname=127.0.0.1", "-Dcom.sun.management.jmxremote.port=" + this.process.managementPort(), "-Dcom.sun.management.jmxremote.rmi.port=" + this.process.managementPort(), "-Dcom.sun.management.jmxremote.local.only=true", "-Dcom.sun.management.jmxremote.authenticate=false", "-Dcom.sun.management.jmxremote.ssl=false", "-XX:+StartAttachListener");
    }

    private void notifyWhenStop() {
        try {
            this.listener.onStop(this.process, this.systemProcess.waitFor());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

