/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.cesar.datahub.events.Operations;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.process.ProcessConnector;
import io.intino.consul.box.process.ProcessManager;
import io.intino.consul.graph.Process;
import java.io.IOException;
import java.util.Arrays;

public class ProcessOperationsAction {
    public String processId;
    public ConsulBox box;

    public Operations execute() {
        Process process = ProcessFinder.processFromIdentifier(this.box.graph(), this.processId);
        ProcessManager processManager = this.box.processManager();
        boolean running = processManager.isRunning(ProcessFinder.processFromIdentifier(this.box.graph(), this.processId));
        Operations operations = new Operations();
        if (!running) {
            return operations;
        }
        ProcessConnector connector = new ProcessConnector(process);
        try {
            connector.connect();
            connector.operations().forEach(o -> {
                OperationExtractor method = new OperationExtractor(o.split(":")[0]);
                Operations.Operation operation = new Operations.Operation().name(method.methodName).returnType(method.returnType).description(o.split(":")[1].trim());
                if (!method.parameters.isEmpty()) {
                    operation.parameters(Arrays.asList(method.parameters.split(",")));
                }
                operations.operationList().add(operation);
            });
            return operations;
        }
        catch (IOException e) {
            return operations;
        }
    }

    static class OperationExtractor {
        private final String returnType;
        private final String methodName;
        private final String parameters;

        OperationExtractor(String methodSignature) {
            this.returnType = this.getReturn(this.clean(methodSignature));
            this.methodName = this.getMethod(this.clean(methodSignature));
            this.parameters = OperationExtractor.getParameters(this.clean(methodSignature));
        }

        private String clean(String methodSignature) {
            return methodSignature.trim().replaceAll("\\s+", " ").replace(" (", "(");
        }

        private String getReturn(String methodSignature) {
            String returnValue = methodSignature.split(" (\\S)*\\(")[0];
            return returnValue.startsWith("public ") ? returnValue.replaceFirst("public ", "") : returnValue;
        }

        private String getMethod(String methodSignature) {
            String[] substring = methodSignature.substring(0, methodSignature.indexOf(40)).split(" ");
            return substring[substring.length - 1];
        }

        private static String getParameters(String methodSignature) {
            return methodSignature.substring(methodSignature.indexOf(40) + 1, methodSignature.length() - 1);
        }
    }
}

