/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.process.ProcessConnector;
import io.intino.consul.box.process.ProcessManager;
import io.intino.consul.box.schemas.ProcessStatus;
import io.intino.consul.graph.Process;

public class GetProcessStatusAction {
    public ConsulBox box;
    public SparkContext context;
    public String process;

    public ProcessStatus execute() throws BadRequest {
        Process process = ProcessFinder.processFromShortName(this.box.graph(), this.process);
        if (process == null || !process.deployed()) {
            return new ProcessStatus().running(false).id(this.process);
        }
        ProcessManager manager = this.box.processManager();
        boolean running = manager.isRunning(process);
        Logger.info("Status of " + process.identifier() + " sent");
        return running ? this.runningStatus(process) : this.defaultStatus(process).running(false).exitValue(manager.exitValue(process));
    }

    private ProcessStatus runningStatus(Process process) {
        try {
            ProcessConnector connector = new ProcessConnector(process).connect();
            io.intino.cesar.datahub.events.consul.process.ProcessStatus status = connector.status();
            if (status == null) {
                return this.defaultStatus(process).running(true);
            }
            connector.disconnect();
            return new ProcessStatus().cpu(status.cpu()).memory(status.memory()).threads(status.threads()).id(process.identifier()).exitValue(-1);
        }
        catch (Throwable e) {
            return this.defaultStatus(process).running(true);
        }
    }

    private ProcessStatus defaultStatus(Process process) {
        return new ProcessStatus().id(process.identifier()).debugPort(process.debugPort());
    }

    public void onMalformedRequest(Throwable e) throws BadRequest {
        throw new BadRequest("Malformed request");
    }
}

