/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.rest.RequestErrorHandler;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.graph.Process;
import java.util.List;
import java.util.stream.Collectors;

public class GetProcessParametersAction
implements RequestErrorHandler {
    public ConsulBox box;
    public SparkContext context;
    public String process;

    public List<String> execute() throws BadRequest {
        Process process = ProcessFinder.processFromIdentifier(this.box.graph(), this.process);
        if (process == null) {
            process = ProcessFinder.processFromShortName(this.box.graph(), this.process);
        }
        if (process == null) {
            throw new BadRequest("Process not found");
        }
        return process.parameterList().stream().map(p -> p.name() + "=" + p.value()).collect(Collectors.toList());
    }

    @Override
    public void onMalformedRequest(Throwable e) throws AlexandriaException {
        throw new BadRequest("Malformed request");
    }
}

