/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.jmx.JMXServer;
import io.intino.alexandria.logger.Formatter;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.box.ApiRestService;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.JMXJmx;
import io.intino.consul.box.Sentinels;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected ConsulConfiguration configuration;
    protected JMXServer jmx;
    private AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public AbstractBox(String[] args) {
        this(new ConsulConfiguration(args));
    }

    public AbstractBox(ConsulConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    @Override
    public ConsulConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Box put(Object o) {
        return this;
    }

    @Override
    public abstract void beforeStart();

    @Override
    public Box start() {
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    @Override
    public abstract void afterStart();

    @Override
    public abstract void beforeStop();

    @Override
    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    @Override
    public void stopServices() {
        AlexandriaSparkBuilder.instance().stop();
    }

    @Override
    public abstract void afterStop();

    @Override
    public void startServices() {
        this.initUI();
        this.initConnector();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initDatalake();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initAgenda();
    }

    public AlexandriaScheduler scheduler() {
        return this.scheduler;
    }

    private void initRestServices() {
        if ("15000".isEmpty()) {
            return;
        }
        AlexandriaSparkBuilder.setup(Integer.parseInt("15000"), "www/");
        ApiRestService.setup(AlexandriaSparkBuilder.instance(), (ConsulBox)this);
        AlexandriaSparkBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info("Rest service api-rest: started at port 15000!");
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
        this.jmx = new JMXJmx().init((ConsulBox)this);
        io.intino.alexandria.logger.Logger.info("Jmx service jmx: started!");
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    private void initDatalake() {
    }

    private void initConnector() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
        Sentinels.init(this.scheduler, this.configuration.home(), (ConsulBox)this);
    }

    private void initWorkflow() {
    }

    private void initAgenda() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter(new Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    protected URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

