/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import io.intino.alexandria.Timetag;

public class Fingerprint {
    private static final String SEPARATOR = "/";
    private String fingerprint;

    public Fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public static Fingerprint of(String tank, Timetag timetag) {
        return new Fingerprint(tank + SEPARATOR + timetag);
    }

    public static Fingerprint of(String tank, Timetag timetag, String set) {
        return new Fingerprint(tank + SEPARATOR + timetag + SEPARATOR + set);
    }

    public String tank() {
        return this.fingerprint.split(SEPARATOR)[0];
    }

    public Timetag timetag() {
        return new Timetag(this.fingerprint.split(SEPARATOR)[1]);
    }

    public String set() {
        try {
            return this.fingerprint.split(SEPARATOR)[2];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int size() {
        return this.fingerprint.length();
    }

    public String toString() {
        return this.fingerprint;
    }

    public boolean equals(Object o) {
        return this.fingerprint.equals(o.toString());
    }

    public int hashCode() {
        return this.fingerprint.hashCode();
    }

    public String name() {
        return this.fingerprint.replace(SEPARATOR, "-");
    }
}

