/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.TextMimeType;
import eu.medsea.mimeutil.detector.MimeDetector;
import eu.medsea.mimeutil.handler.TextMimeHandler;
import eu.medsea.util.EncodingGuesser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextMimeDetector
extends MimeDetector {
    private static Logger log;
    private static final int BUFFER_SIZE = 1024;
    private static final int MAX_NULL_VALUES = 2;
    private static Collection preferredEncodings;
    private static Collection handlers;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("eu.medsea.mimeutil.TextMimeDetector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger(clazz);
        preferredEncodings = new ArrayList();
        TextMimeDetector.setPreferredEncodings(new String[]{"UTF-16", "UTF-8", "ISO-8859-1", "windows-1252", "US-ASCII"});
        handlers = new ArrayList();
    }

    private TextMimeDetector() {
    }

    TextMimeDetector(int dummy) {
        this();
    }

    public String getDescription() {
        return "Determine if a file or stream contains a text mime type. If so then return TextMimeType with text/plain and the best guess encoding.";
    }

    public Collection getMimeTypesFileName(String fileName) throws UnsupportedOperationException {
        return this.getMimeTypesFile(new File(fileName));
    }

    public Collection getMimeTypesURL(URL url) throws UnsupportedOperationException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(MimeUtil.getInputStreamForURL(url));
            Collection collection = this.getMimeTypesInputStream(in);
            return collection;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignore) {
                log.error(ignore.getLocalizedMessage());
            }
        }
    }

    public Collection getMimeTypesFile(File file) throws UnsupportedOperationException {
        if (!file.exists()) {
            throw new UnsupportedOperationException("This MimeDetector requires actual content.");
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            Collection collection = this.getMimeTypesInputStream(in);
            return collection;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignore) {
                log.error(ignore.getLocalizedMessage());
            }
        }
    }

    public Collection getMimeTypesInputStream(InputStream in) throws UnsupportedOperationException {
        int offset = 0;
        int len = 1024;
        byte[] data = new byte[len];
        byte[] copy = null;
        in.mark(len);
        try {
            try {
                int restBytesToRead = len;
                while (restBytesToRead > 0) {
                    int bytesRead = in.read(data, offset, restBytesToRead);
                    if (bytesRead < 0) break;
                    offset += bytesRead;
                    restBytesToRead -= bytesRead;
                }
                if (offset < len) {
                    copy = new byte[offset];
                    System.arraycopy(data, 0, copy, 0, offset);
                } else {
                    copy = data;
                }
            }
            catch (IOException ioe) {
                throw new MimeException(ioe);
            }
        }
        finally {
            try {
                in.reset();
            }
            catch (Exception e) {
                throw new MimeException(e);
            }
        }
        return this.getMimeTypesByteArray(copy);
    }

    public Collection getMimeTypesByteArray(byte[] data) throws UnsupportedOperationException {
        if (EncodingGuesser.getSupportedEncodings().isEmpty() || this.isBinary(data)) {
            throw new UnsupportedOperationException();
        }
        ArrayList<TextMimeType> mimeTypes = new ArrayList<TextMimeType>();
        Collection possibleEncodings = EncodingGuesser.getPossibleEncodings(data);
        if (log.isDebugEnabled()) {
            log.debug("Possible encodings [" + possibleEncodings.size() + "] " + possibleEncodings);
        }
        if (possibleEncodings.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        String encoding = null;
        Iterator it = preferredEncodings.iterator();
        while (it.hasNext()) {
            encoding = (String)it.next();
            if (!possibleEncodings.contains(encoding)) continue;
            mimeTypes.add(new TextMimeType("text/plain", encoding));
            break;
        }
        if (mimeTypes.isEmpty() && possibleEncodings.contains(EncodingGuesser.getDefaultEncoding())) {
            encoding = EncodingGuesser.getDefaultEncoding();
            mimeTypes.add(new TextMimeType("text/plain", encoding));
        }
        if (mimeTypes.isEmpty()) {
            it = possibleEncodings.iterator();
            encoding = (String)it.next();
            mimeTypes.add(new TextMimeType("text/plain", encoding));
        }
        if (mimeTypes.isEmpty() || handlers.isEmpty()) {
            return mimeTypes;
        }
        try {
            int lengthBOM = EncodingGuesser.getLengthBOM(encoding, data);
            String content = new String(EncodingGuesser.getByteArraySubArray(data, lengthBOM, data.length - lengthBOM), encoding);
            return this.fireMimeHandlers(mimeTypes, content);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return mimeTypes;
        }
    }

    public static void setPreferredEncodings(String[] encodings) {
        preferredEncodings = EncodingGuesser.getValidEncodings(encodings);
        if (log.isDebugEnabled()) {
            log.debug("Preferred Encodings set to " + preferredEncodings);
        }
    }

    public static void registerTextMimeHandler(TextMimeHandler handler) {
        handlers.add(handler);
    }

    public static void unregisterTextMimeHandler(TextMimeHandler handler) {
        handlers.remove(handler);
    }

    public static Collection getRegisteredTextMimeHandlers() {
        return handlers;
    }

    private Collection fireMimeHandlers(Collection mimeTypes, String content) {
        TextMimeType mimeType = (TextMimeType)mimeTypes.iterator().next();
        Iterator it = handlers.iterator();
        while (it.hasNext()) {
            TextMimeHandler tmh = (TextMimeHandler)it.next();
            if (tmh.handle(mimeType, content)) break;
        }
        return mimeTypes;
    }

    private boolean isBinary(byte[] data) {
        int negCount = 0;
        int i = 0;
        while (i < data.length) {
            negCount = data[i] == 0 ? ++negCount : 0;
            if (negCount == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

