/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.services.rds.model.DBSecurityGroupMembership;
import com.amazonaws.services.rds.model.OptionSetting;
import com.amazonaws.services.rds.model.VpcSecurityGroupMembership;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Option
implements Serializable {
    private String optionName;
    private String optionDescription;
    private Boolean persistent;
    private Integer port;
    private List<OptionSetting> optionSettings;
    private List<DBSecurityGroupMembership> dBSecurityGroupMemberships;
    private List<VpcSecurityGroupMembership> vpcSecurityGroupMemberships;

    public String getOptionName() {
        return this.optionName;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public Option withOptionName(String optionName) {
        this.optionName = optionName;
        return this;
    }

    public String getOptionDescription() {
        return this.optionDescription;
    }

    public void setOptionDescription(String optionDescription) {
        this.optionDescription = optionDescription;
    }

    public Option withOptionDescription(String optionDescription) {
        this.optionDescription = optionDescription;
        return this;
    }

    public Boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public Option withPersistent(Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public Boolean getPersistent() {
        return this.persistent;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Option withPort(Integer port) {
        this.port = port;
        return this;
    }

    public List<OptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new ArrayList<OptionSetting>();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<OptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        ArrayList<OptionSetting> optionSettingsCopy = new ArrayList<OptionSetting>(optionSettings.size());
        optionSettingsCopy.addAll(optionSettings);
        this.optionSettings = optionSettingsCopy;
    }

    public Option withOptionSettings(OptionSetting ... optionSettings) {
        if (this.getOptionSettings() == null) {
            this.setOptionSettings(new ArrayList<OptionSetting>(optionSettings.length));
        }
        for (OptionSetting value : optionSettings) {
            this.getOptionSettings().add(value);
        }
        return this;
    }

    public Option withOptionSettings(Collection<OptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
        } else {
            ArrayList<OptionSetting> optionSettingsCopy = new ArrayList<OptionSetting>(optionSettings.size());
            optionSettingsCopy.addAll(optionSettings);
            this.optionSettings = optionSettingsCopy;
        }
        return this;
    }

    public List<DBSecurityGroupMembership> getDBSecurityGroupMemberships() {
        if (this.dBSecurityGroupMemberships == null) {
            this.dBSecurityGroupMemberships = new ArrayList<DBSecurityGroupMembership>();
        }
        return this.dBSecurityGroupMemberships;
    }

    public void setDBSecurityGroupMemberships(Collection<DBSecurityGroupMembership> dBSecurityGroupMemberships) {
        if (dBSecurityGroupMemberships == null) {
            this.dBSecurityGroupMemberships = null;
            return;
        }
        ArrayList<DBSecurityGroupMembership> dBSecurityGroupMembershipsCopy = new ArrayList<DBSecurityGroupMembership>(dBSecurityGroupMemberships.size());
        dBSecurityGroupMembershipsCopy.addAll(dBSecurityGroupMemberships);
        this.dBSecurityGroupMemberships = dBSecurityGroupMembershipsCopy;
    }

    public Option withDBSecurityGroupMemberships(DBSecurityGroupMembership ... dBSecurityGroupMemberships) {
        if (this.getDBSecurityGroupMemberships() == null) {
            this.setDBSecurityGroupMemberships(new ArrayList<DBSecurityGroupMembership>(dBSecurityGroupMemberships.length));
        }
        for (DBSecurityGroupMembership value : dBSecurityGroupMemberships) {
            this.getDBSecurityGroupMemberships().add(value);
        }
        return this;
    }

    public Option withDBSecurityGroupMemberships(Collection<DBSecurityGroupMembership> dBSecurityGroupMemberships) {
        if (dBSecurityGroupMemberships == null) {
            this.dBSecurityGroupMemberships = null;
        } else {
            ArrayList<DBSecurityGroupMembership> dBSecurityGroupMembershipsCopy = new ArrayList<DBSecurityGroupMembership>(dBSecurityGroupMemberships.size());
            dBSecurityGroupMembershipsCopy.addAll(dBSecurityGroupMemberships);
            this.dBSecurityGroupMemberships = dBSecurityGroupMembershipsCopy;
        }
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroupMemberships() {
        if (this.vpcSecurityGroupMemberships == null) {
            this.vpcSecurityGroupMemberships = new ArrayList<VpcSecurityGroupMembership>();
        }
        return this.vpcSecurityGroupMemberships;
    }

    public void setVpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> vpcSecurityGroupMemberships) {
        if (vpcSecurityGroupMemberships == null) {
            this.vpcSecurityGroupMemberships = null;
            return;
        }
        ArrayList<VpcSecurityGroupMembership> vpcSecurityGroupMembershipsCopy = new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroupMemberships.size());
        vpcSecurityGroupMembershipsCopy.addAll(vpcSecurityGroupMemberships);
        this.vpcSecurityGroupMemberships = vpcSecurityGroupMembershipsCopy;
    }

    public Option withVpcSecurityGroupMemberships(VpcSecurityGroupMembership ... vpcSecurityGroupMemberships) {
        if (this.getVpcSecurityGroupMemberships() == null) {
            this.setVpcSecurityGroupMemberships(new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroupMemberships.length));
        }
        for (VpcSecurityGroupMembership value : vpcSecurityGroupMemberships) {
            this.getVpcSecurityGroupMemberships().add(value);
        }
        return this;
    }

    public Option withVpcSecurityGroupMemberships(Collection<VpcSecurityGroupMembership> vpcSecurityGroupMemberships) {
        if (vpcSecurityGroupMemberships == null) {
            this.vpcSecurityGroupMemberships = null;
        } else {
            ArrayList<VpcSecurityGroupMembership> vpcSecurityGroupMembershipsCopy = new ArrayList<VpcSecurityGroupMembership>(vpcSecurityGroupMemberships.size());
            vpcSecurityGroupMembershipsCopy.addAll(vpcSecurityGroupMemberships);
            this.vpcSecurityGroupMemberships = vpcSecurityGroupMembershipsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptionName() != null) {
            sb.append("OptionName: " + this.getOptionName() + ",");
        }
        if (this.getOptionDescription() != null) {
            sb.append("OptionDescription: " + this.getOptionDescription() + ",");
        }
        if (this.isPersistent() != null) {
            sb.append("Persistent: " + this.isPersistent() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: " + this.getOptionSettings() + ",");
        }
        if (this.getDBSecurityGroupMemberships() != null) {
            sb.append("DBSecurityGroupMemberships: " + this.getDBSecurityGroupMemberships() + ",");
        }
        if (this.getVpcSecurityGroupMemberships() != null) {
            sb.append("VpcSecurityGroupMemberships: " + this.getVpcSecurityGroupMemberships());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptionName() == null ? 0 : this.getOptionName().hashCode());
        hashCode = 31 * hashCode + (this.getOptionDescription() == null ? 0 : this.getOptionDescription().hashCode());
        hashCode = 31 * hashCode + (this.isPersistent() == null ? 0 : this.isPersistent().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : ((Object)this.getOptionSettings()).hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroupMemberships() == null ? 0 : ((Object)this.getDBSecurityGroupMemberships()).hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupMemberships() == null ? 0 : ((Object)this.getVpcSecurityGroupMemberships()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        if (other.getOptionName() == null ^ this.getOptionName() == null) {
            return false;
        }
        if (other.getOptionName() != null && !other.getOptionName().equals(this.getOptionName())) {
            return false;
        }
        if (other.getOptionDescription() == null ^ this.getOptionDescription() == null) {
            return false;
        }
        if (other.getOptionDescription() != null && !other.getOptionDescription().equals(this.getOptionDescription())) {
            return false;
        }
        if (other.isPersistent() == null ^ this.isPersistent() == null) {
            return false;
        }
        if (other.isPersistent() != null && !other.isPersistent().equals(this.isPersistent())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        if (other.getOptionSettings() != null && !((Object)other.getOptionSettings()).equals(this.getOptionSettings())) {
            return false;
        }
        if (other.getDBSecurityGroupMemberships() == null ^ this.getDBSecurityGroupMemberships() == null) {
            return false;
        }
        if (other.getDBSecurityGroupMemberships() != null && !((Object)other.getDBSecurityGroupMemberships()).equals(this.getDBSecurityGroupMemberships())) {
            return false;
        }
        if (other.getVpcSecurityGroupMemberships() == null ^ this.getVpcSecurityGroupMemberships() == null) {
            return false;
        }
        return other.getVpcSecurityGroupMemberships() == null || ((Object)other.getVpcSecurityGroupMemberships()).equals(this.getVpcSecurityGroupMemberships());
    }
}

