/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework.stores;

import io.intino.magritte.framework.stores.FileSystemStore;
import io.intino.magritte.io.Stash;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class InMemoryFileStore
extends FileSystemStore {
    boolean firstLoad = true;

    public InMemoryFileStore(File file) {
        super(file);
    }

    @Override
    public Stash stashFrom(String path) {
        Stash stash = super.stashFrom(path);
        if (stash == null) {
            return null;
        }
        return this.firstLoad ? this.includeAllTheStore(stash, path) : stash;
    }

    private Stash includeAllTheStore(Stash stash, String path) {
        this.firstLoad = false;
        stash.uses.addAll(this.allStashesInStore());
        stash.uses.remove(path);
        stash.uses.remove(stash.language + ".stash");
        return stash;
    }

    private List<String> allStashesInStore() {
        try {
            if (!this.file.exists()) {
                return new ArrayList<String>();
            }
            final ArrayList<String> result = new ArrayList<String>();
            Files.walkFileTree(this.file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().toLowerCase().endsWith(".stash")) {
                        result.add(InMemoryFileStore.this.relativePathOf(file.toUri().toURL()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }
}

