/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework;

import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.StashWriter;
import io.intino.magritte.framework.utils.StashHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class GraphHelper {
    GraphHelper() {
    }

    static <T extends GraphWrapper> T create(Class<T> aClass, Graph graph) {
        try {
            GraphWrapper instance = (GraphWrapper)aClass.getConstructor(Graph.class).newInstance(graph);
            instance.update();
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static <T extends GraphWrapper> T create(Class<T> aClass, Graph graph, GraphWrapper wrapper) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return (T)((GraphWrapper)aClass.getConstructor(Graph.class, aClass).newInstance(graph, wrapper));
    }

    static void saveStashes(Graph graph, String[] paths) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(paths));
        HashMap<String, List<Node>> pathNodes = new HashMap<String, List<Node>>();
        set.forEach(p -> pathNodes.put((String)p, new ArrayList()));
        for (Node node : graph.model.graph.rootList()) {
            if (node == null || !set.contains(node.stash())) continue;
            ((List)pathNodes.get(node.stash())).add(node);
        }
        GraphHelper.save(graph, pathNodes);
    }

    static void saveAll(Graph graph, String[] excludedPaths) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(excludedPaths));
        HashMap<String, List<Node>> pathNodes = new HashMap<String, List<Node>>();
        for (Node node : graph.model.graph.rootList()) {
            if (node == null || set.contains(node.stash())) continue;
            if (!pathNodes.containsKey(node.stash())) {
                pathNodes.put(node.stash(), new ArrayList());
            }
            ((List)pathNodes.get(node.stash())).add(node);
        }
        GraphHelper.save(graph, pathNodes);
    }

    private static void save(Graph graph, Map<String, List<Node>> pathNodes) {
        for (Map.Entry<String, List<Node>> entry : pathNodes.entrySet()) {
            StashWriter.write(graph, StashHelper.stashWithExtension(entry.getKey()), entry.getValue());
        }
    }

    static Node createNode(Graph graph, Concept concept, String path, String name) {
        if (!concept.isMain()) {
            Logger.getGlobal().severe("Concept " + concept.id() + " is not main. The node could not be created.");
            return null;
        }
        if (concept.isAbstract()) {
            Logger.getGlobal().severe("Concept " + concept.id() + " is abstract. The node could not be created.");
            return null;
        }
        path = path == null || path.isEmpty() ? "Misc" : path;
        graph.doLoadStashes(graph.stashOf(StashHelper.stashWithExtension(path), false));
        if (name != null && graph.nodes.containsKey(path + "#" + name)) {
            Logger.getGlobal().warning("Node with id " + path + "#" + name + " already exists");
            return null;
        }
        return concept.createRoot(StashHelper.canonicalPath(path), name == null ? graph.createNodeName() : name, graph.model);
    }
}

