/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.logger.Logger;
import io.intino.cesar.datahub.events.consul.server.ServerBoot;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.Utils;
import io.intino.consul.box.actions.ScheduleServerStatusAction;
import io.intino.consul.box.oshi.ServerInfoProvider;
import io.intino.consul.graph.Info;
import io.intino.consul.graph.Process;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class NotifyBootAction {
    public ConsulBox box;
    public Context context = new Context();

    public void execute() {
        ServerBoot serverBoot = this.serverBoot();
        if (this.box.terminal() != null) {
            this.box.terminal().publish(serverBoot);
        }
        Logger.info("Boot notified");
        if (this.box.graph().info() == null) {
            this.box.graph().create().info(this.box.serverId(), serverBoot.diskSize(), serverBoot.memorySize().longValue(), serverBoot.ip(), Info.Scope.valueOf(this.box.configuration().scope().toUpperCase()));
        } else {
            this.box.graph().info().diskSize(serverBoot.diskSize()).memorySize(serverBoot.memorySize().longValue()).ip(serverBoot.ip());
        }
        ScheduleServerStatusAction action = new ScheduleServerStatusAction();
        action.box = this.box;
        action.execute();
    }

    private ServerBoot serverBoot() {
        ServerInfoProvider provider = new ServerInfoProvider();
        return new ServerBoot().ts(Instant.now()).id(this.box.serverId()).version(Utils.currentVersion()).appsWorkspace(this.box.applicationsWorkspace().getAbsolutePath()).scope(this.box.configuration().scope()).ip(provider.ip()).architecture(System.getProperty("os.arch")).jvm(System.getProperty("java.version")).os(System.getProperty("os.name")).cores(provider.cores()).deployUser(this.box.configuration().deployUser()).diskSize(provider.hddCapacityInMb(this.box.applicationsWorkspace().getAbsolutePath())).memorySize(provider.memoryCapacityInMb()).processInfoList(this.processInfos());
    }

    private List<ServerBoot.ProcessInfo> processInfos() {
        ArrayList<ServerBoot.ProcessInfo> list = new ArrayList<ServerBoot.ProcessInfo>();
        for (Process process : this.box.graph().processList()) {
            list.add(new ServerBoot.ProcessInfo().id(process.identifier()).artifact(process.artifact().identifier()).jmxPort(process.managementPort()).parameterList(process.parameterList().stream().map(p -> new ServerBoot.ProcessInfo.Parameter().name(p.name()).value(p.value())).collect(Collectors.toList())).classpathPrefix(process.artifact().classpathPrefix()).artifactoryList(process.artifact().artifactoryList().stream().map(a -> new ServerBoot.ProcessInfo.Artifactory().id(a.mavenId()).password(a.password()).url(a.url()).user(a.user())).collect(Collectors.toList())).minMemory(process.requirements() != null ? process.requirements().minMemory() : 0).maxMemory(process.requirements() != null ? process.requirements().maxMemory() : 0));
        }
        return list;
    }
}

