/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.process.ProcessHandler;
import io.intino.consul.box.process.RestartProcessOnStop;
import io.intino.consul.graph.Process;
import java.util.Comparator;

public class LaunchProcessesOnStartAction {
    public ConsulBox box;

    public void execute() {
        this.sleep(5);
        this.box.graph().processList(process -> !process.status().equals((Object)Process.Status.Stopped)).sorted(Comparator.comparing(Process::creationTime)).forEach(s -> {
            if (this.box.isShuttingDown()) {
                return;
            }
            s.processHandler(new ProcessHandler((Process)s, this.box.configuration(), this.box.applicationsWorkspace(), this.box.applicationsDirectory().getAbsoluteFile(), this.box.localRepository(), this.box.logHandler(), new RestartProcessOnStop(this.box)));
            this.box.processManager().start((Process)s);
            this.sleep(30);
        });
        Logger.info("Starting launch finished");
        this.box.processLaunchedOnStart(true);
    }

    private void sleep(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

