/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.jms.BusConnector;
import io.intino.alexandria.jms.ConnectionListener;
import io.intino.alexandria.jms.DurableTopicConsumer;
import io.intino.alexandria.jms.JmsConsumer;
import io.intino.alexandria.jms.JmsProducer;
import io.intino.alexandria.jms.MessageReader;
import io.intino.alexandria.jms.MessageWriter;
import io.intino.alexandria.jms.QueueConsumer;
import io.intino.alexandria.jms.QueueProducer;
import io.intino.alexandria.jms.TopicConsumer;
import io.intino.alexandria.jms.TopicProducer;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.terminal.Broker;
import io.intino.alexandria.terminal.Connector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.command.ActiveMQDestination;

public class DatahubConnector
implements Connector {
    private final String brokerUrl;
    private final String user;
    private final String password;
    private final String clientId;
    private final Map<String, JmsProducer> producers;
    private final Map<String, List<JmsConsumer>> consumers;
    private final List<Map.Entry<String, Consumer<javax.jms.Message>>> consumersPendingToRegister;
    private final List<Subscription> subscribersPendingToRegister;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Connection connection;
    private Session session;
    private ScheduledExecutorService scheduler;

    public DatahubConnector(String brokerUrl, String user, String password, String clientId) {
        this.brokerUrl = brokerUrl;
        this.user = user;
        this.password = password;
        this.clientId = clientId;
        this.producers = new ConcurrentHashMap<String, JmsProducer>();
        this.consumers = new ConcurrentHashMap<String, List<JmsConsumer>>();
        this.consumersPendingToRegister = new ArrayList<Map.Entry<String, Consumer<javax.jms.Message>>>();
        this.subscribersPendingToRegister = new ArrayList<Subscription>();
    }

    public void start() {
        if (this.brokerUrl == null || this.brokerUrl.isEmpty()) {
            Logger.warn("Invalid broker URL. Connection aborted");
            return;
        }
        try {
            this.connect();
        }
        catch (JMSException e) {
            Logger.error(e);
        }
        this.started.set(true);
        if (this.scheduler == null) {
            this.scheduler = Executors.newScheduledThreadPool(1);
            this.scheduler.scheduleAtFixedRate(this::checkConnection, 1L, 1L, TimeUnit.MINUTES);
        }
    }

    private void connect() throws JMSException {
        if (!Broker.isRunning(this.brokerUrl)) {
            Logger.warn("Broker Unreachable. Connection aborted.");
            return;
        }
        this.createConnection();
        if (this.connection != null && ((ActiveMQConnection)this.connection).isStarted()) {
            this.session = this.createSession();
            if (this.session != null && ((ActiveMQSession)this.session).isRunning()) {
                this.connected.set(true);
                this.consumersPendingToRegister.forEach(e -> this.attach((String)e.getKey(), (Consumer)e.getValue()));
                this.subscribersPendingToRegister.forEach(s -> this.attach(s.path, s.subscriberId, s.consumer));
                this.consumersPendingToRegister.clear();
                this.subscribersPendingToRegister.clear();
            }
        }
    }

    @Override
    public void sendEvent(String path, Event event) {
        if (this.cannotSendMessage()) {
            return;
        }
        try {
            JmsProducer producer = this.topicProducer(path);
            if (producer == null) {
                return;
            }
            this.sendMessage(producer, DatahubConnector.serialize(event));
        }
        catch (IOException | JMSException e) {
            Logger.error(e);
        }
    }

    @Override
    public void sendEvent(String path, Event event, int expirationInSeconds) {
    }

    @Override
    public void sendEvents(String path, List<Event> events) {
    }

    @Override
    public void sendEvents(String path, List<Event> events, int expirationInSeconds) {
    }

    @Override
    public void sendMessage(String path, String message) {
        if (this.cannotSendMessage()) {
            return;
        }
        try {
            this.sendMessage(this.queueProducer(path), DatahubConnector.serialize(message));
        }
        catch (IOException | JMSException e) {
            Logger.error(e);
        }
    }

    @Override
    public void attachListener(String path, Consumer<Event> onEventReceived) {
        Consumer<javax.jms.Message> messageConsumer = e -> onEventReceived.accept(new Event(MessageDeserializer.deserialize(e)));
        if (this.session == null) {
            this.consumersPendingToRegister.add(new AbstractMap.SimpleEntry<String, Consumer<javax.jms.Message>>(path, messageConsumer));
        } else {
            this.attach(path, messageConsumer);
        }
    }

    @Override
    public void attachListener(String path, String subscriberId, Consumer<Event> onEventReceived) {
        Consumer<javax.jms.Message> messageConsumer = e -> onEventReceived.accept(new Event(MessageDeserializer.deserialize(e)));
        if (this.session == null) {
            this.subscribersPendingToRegister.add(new Subscription(path, subscriberId, messageConsumer));
        } else {
            this.attach(path, subscriberId, messageConsumer);
        }
    }

    @Override
    public void attachListener(String path, String subscriberId, Consumer<Event> onEventReceived, Predicate<Instant> filter) {
    }

    private void attach(String path, Consumer<javax.jms.Message> messageConsumer) {
        try {
            TopicConsumer topicConsumer = new TopicConsumer(this.session, path);
            topicConsumer.listen(messageConsumer);
            this.consumersOf(path).add(topicConsumer);
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    private void attach(String path, String subscriberId, Consumer<javax.jms.Message> messageConsumer) {
        try {
            DurableTopicConsumer consumer = new DurableTopicConsumer(this.session, path, subscriberId);
            consumer.listen(messageConsumer);
            this.consumersOf(path).add(consumer);
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    @Override
    public void attachListener(String path, Connector.MessageConsumer onMessageReceived) {
        if (this.session == null) {
            this.consumersPendingToRegister.add(new AbstractMap.SimpleEntry<String, Consumer<javax.jms.Message>>(path, m -> onMessageReceived.accept(MessageReader.textFrom(m), this.callback((javax.jms.Message)m))));
            return;
        }
        try {
            QueueConsumer consumer = new QueueConsumer(this.session, path);
            this.consumersOf(path).add(consumer);
            consumer.listen(m -> onMessageReceived.accept(MessageReader.textFrom(m), this.callback((javax.jms.Message)m)));
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    @Override
    public void detachListeners(Consumer<Event> consumer) {
    }

    @Override
    public void detachListeners(Connector.MessageConsumer messageConsumer) {
    }

    @Override
    public void detachListeners(String path) {
        this.consumers.get(path);
    }

    @Override
    public void createSubscription(String path, String subscriberId) {
    }

    @Override
    public void destroySubscription(String subscriberId) {
    }

    @Override
    public void requestResponse(String path, String subscriberId, Consumer<String> consumer) {
    }

    @Override
    public void requestResponse(String s, String subscriberId, String responsePath) {
    }

    private JmsProducer topicProducer(String path) throws JMSException {
        if (((ActiveMQSession)this.session).isClosed()) {
            return null;
        }
        if (!this.producers.containsKey(path)) {
            this.producers.put(path, new TopicProducer(this.session, path));
        }
        return this.producers.get(path);
    }

    private JmsProducer queueProducer(String path) throws JMSException {
        if (!this.producers.containsKey(path)) {
            this.producers.put(path, new QueueProducer(this.session, path));
        }
        return this.producers.get(path);
    }

    private synchronized List<JmsConsumer> consumersOf(String path) {
        if (!this.consumers.containsKey(path)) {
            this.consumers.put(path, new CopyOnWriteArrayList());
        }
        return this.consumers.get(path);
    }

    private void sendMessage(JmsProducer producer, javax.jms.Message message) {
        try {
            Thread thread = new Thread(() -> producer.produce(message));
            thread.start();
            thread.join(1000L);
            thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean cannotSendMessage() {
        return this.session == null || !this.connected.get();
    }

    private void createConnection() {
        try {
            this.connection = BusConnector.createConnection(this.brokerUrl, this.user, this.password, new ConnectionListener(){

                @Override
                public void transportInterupted() {
                    Logger.warn("Connection with DataHub interrupted");
                }

                @Override
                public void transportResumed() {
                    Logger.info("Connection with DataHub established");
                }
            });
            if (this.connection != null) {
                if (this.clientId != null && !this.clientId.isEmpty()) {
                    this.connection.setClientID(this.clientId);
                }
                this.connection.start();
            }
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    public void stop() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.session = null;
            this.connection = null;
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private Session createSession() throws JMSException {
        return this.connection.createSession(false, 1);
    }

    private void checkConnection() {
        if (this.session != null && this.brokerUrl.startsWith("failover") && !this.connected.get()) {
            Logger.debug("Data-hub currently disconnected. Waiting for reconnection...");
            return;
        }
        if (this.connection != null && ((ActiveMQConnection)this.connection).isStarted() && this.session != null && ((ActiveMQSession)this.session).isRunning()) {
            this.connected.set(true);
            return;
        }
        Logger.debug("Restarting data-hub connection...");
        this.stop();
        try {
            this.connect();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.connected.set(true);
    }

    private String callback(javax.jms.Message m) {
        try {
            ActiveMQDestination replyTo = (ActiveMQDestination)m.getJMSReplyTo();
            return replyTo == null ? null : replyTo.getPhysicalName();
        }
        catch (JMSException e) {
            return null;
        }
    }

    private static javax.jms.Message serialize(String payload) throws IOException, JMSException {
        return MessageWriter.write(payload);
    }

    private static javax.jms.Message serialize(Event event) throws IOException, JMSException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        io.intino.alexandria.message.MessageWriter messageWriter = new io.intino.alexandria.message.MessageWriter(os);
        messageWriter.write(event.toMessage());
        messageWriter.close();
        return DatahubConnector.serialize(os.toString());
    }

    private static class Subscription {
        String path;
        String subscriberId;
        Consumer<javax.jms.Message> consumer;

        public Subscription(String path, String subscriberId, Consumer<javax.jms.Message> messageConsumer) {
            this.path = path;
            this.subscriberId = subscriberId;
            this.consumer = messageConsumer;
        }
    }

    private static class MessageDeserializer {
        private MessageDeserializer() {
        }

        static Message deserialize(javax.jms.Message message) {
            return new io.intino.alexandria.message.MessageReader(MessageReader.textFrom(message)).next();
        }
    }
}

