/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.terminal.Connector;
import io.intino.cesar.datahub.ConsulTerminal;
import io.intino.cesar.datahub.events.consul.server.ServerLog;
import io.intino.consul.box.AbstractBox;
import io.intino.consul.box.ConsulConfiguration;
import io.intino.consul.box.DatahubConnector;
import io.intino.consul.box.process.ProcessLogger;
import io.intino.consul.box.process.ProcessManager;
import io.intino.consul.box.service.ConsulJmsService;
import io.intino.consul.graph.ConsulGraph;
import io.intino.consul.graph.Process;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.stores.FileSystemStore;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;

public class ConsulBox
extends AbstractBox {
    private final String serverId = this.calculateServerId();
    private DatahubConnector datahubConnector;
    private ConsulTerminal terminal;
    private ConsulJmsService jmsService;
    private ConsulGraph graph;
    private ProcessManager processManager;
    private File applicationsDirectory;
    private ProcessLogger processLogHandler;
    private File applicationsWorkspace;
    private File logsDirectory;
    private boolean processLaunchedOnStart;
    private boolean isShuttingDown = false;

    public ConsulBox(ConsulConfiguration configuration) {
        super(configuration);
        this.init();
    }

    private void init() {
        if (this.configuration.logsDirectory() != null) {
            this.logsDirectory = new File(this.configuration.logsDirectory());
        }
        this.applicationsDirectory = new File(this.configuration.applicationsDirectory());
        this.applicationsWorkspace = this.configuration.applicationsWorkspace() != null ? new File(this.configuration.applicationsWorkspace()) : new File("/home/" + this.configuration().deployUser());
        this.processManager = new ProcessManager(this);
    }

    @Override
    public Box put(Object o) {
        if (o instanceof Graph) {
            this.graph = ((Graph)o).as(ConsulGraph.class);
            if (this.logsDirectory == null) {
                this.logsDirectory = ((FileSystemStore)this.graph().core$().store()).directory();
            }
        }
        super.put(o);
        return this;
    }

    @Override
    public void beforeStart() {
        this.extractScripts();
        this.startConsulTerminal();
    }

    @Override
    public void afterStart() {
        this.processLogHandler = new ProcessLogger(this.serverId(), this.logsDirectory, this.terminal, this.configuration().deployUser(), this.configuration().deployGroup(), this.logTruncate(), this.logPublish());
        this.jmsService = new ConsulJmsService(this.datahubConnector(), this);
        this.configureLogger();
    }

    private boolean logPublish() {
        return this.configuration().logsPublish() == null || Boolean.parseBoolean(this.configuration().logsPublish());
    }

    private boolean logTruncate() {
        return this.configuration().logsTruncate() == null || Boolean.parseBoolean(this.configuration().logsTruncate());
    }

    private void extractScripts() {
        try {
            File scripts = this.scriptsDirectory();
            scripts.mkdirs();
            File file = this.rsyncContinuosScript();
            Files.write(file.toPath(), this.getClass().getResourceAsStream("/scripts/rsync-continuous").readAllBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            file.setExecutable(true);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    @Override
    public void beforeStop() {
        this.isShuttingDown = true;
    }

    @Override
    public void afterStop() {
        Logger.info("Shutting down consul");
        this.graph.processList().forEach(p -> this.processManager.stop((Process)p));
        this.graph.processList().stream().filter(p -> this.processManager.isRunning((Process)p)).forEach(p -> this.processManager.kill((Process)p));
    }

    public ConsulTerminal terminal() {
        return this.terminal;
    }

    public Connector datahubConnector() {
        return this.datahubConnector;
    }

    public ConsulGraph graph() {
        return this.graph;
    }

    public ProcessManager processManager() {
        return this.processManager;
    }

    public void processManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public File applicationsDirectory() {
        return this.applicationsDirectory;
    }

    public File applicationsWorkspace() {
        return this.applicationsWorkspace;
    }

    public File scriptsDirectory() {
        return new File(this.applicationsDirectory + File.separator + "scripts");
    }

    public File rsyncContinuosScript() {
        return new File(this.scriptsDirectory(), "rsync-continuous");
    }

    public File logsDirectory() {
        return this.logsDirectory;
    }

    public String serverId() {
        return this.serverId;
    }

    public ProcessLogger logHandler() {
        return this.processLogHandler;
    }

    private void startConsulTerminal() {
        this.datahubConnector = new DatahubConnector(this.configuration.datahubUrl(), this.configuration.datahubUser(), this.configuration.datahubPassword(), this.configuration.datahubClientid());
        this.terminal = new ConsulTerminal(this.datahubConnector);
        this.datahubConnector.start();
    }

    private void configureLogger() {
    }

    private String calculateServerId() {
        try {
            return InetAddress.getLocalHost().getHostName().replace(".", "-");
        }
        catch (UnknownHostException e) {
            Logger.error(e.getMessage());
            return "consul-default-server";
        }
    }

    public File localRepository() {
        return this.configuration.localRepositoryDirectory() == null ? new File(System.getProperty("user.home"), ".m2" + File.separator + "repository") : new File(this.configuration.localRepositoryDirectory());
    }

    public void processLaunchedOnStart(boolean processLaunchedOnStart) {
        this.processLaunchedOnStart = processLaunchedOnStart;
    }

    public boolean isProcessLaunchedOnStart() {
        return this.processLaunchedOnStart;
    }

    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    private static class ServerLogHandler
    implements Logger.LogHandler {
        private final ConsulBox box;
        private final ConsulTerminal terminal;

        ServerLogHandler(ConsulBox box) {
            this.box = box;
            this.terminal = box.terminal();
        }

        @Override
        public void publish(String message) {
            if (this.box.isShuttingDown()) {
                return;
            }
            Message next = new MessageReader(message).next();
            if (next == null) {
                return;
            }
            if (!next.contains("ts")) {
                next.set("ts", Instant.now());
            }
            this.terminal.publish(new ServerLog(next));
        }
    }
}

