/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.datahub.events.consul.server;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ServerBoot
extends Event
implements Serializable {
    private List<ProcessInfo> processInfoList = null;

    public ServerBoot() {
        super("ServerBoot");
    }

    public ServerBoot(Event event) {
        this(event.toMessage());
    }

    public ServerBoot(Message message) {
        super(message);
    }

    @Override
    public ServerBoot ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public ServerBoot ss(String ss) {
        super.ss(ss);
        return this;
    }

    public String version() {
        return !this.message.contains("version") ? null : this.message.get("version").asString();
    }

    public String id() {
        return !this.message.contains("id") ? null : this.message.get("id").asString();
    }

    public String scope() {
        return !this.message.contains("scope") ? null : this.message.get("scope").asString();
    }

    public String deployUser() {
        return !this.message.contains("deployUser") ? null : this.message.get("deployUser").asString();
    }

    public String appsWorkspace() {
        return !this.message.contains("appsWorkspace") ? null : this.message.get("appsWorkspace").asString();
    }

    public String ip() {
        return !this.message.contains("ip") ? null : this.message.get("ip").asString();
    }

    public String architecture() {
        return !this.message.contains("architecture") ? null : this.message.get("architecture").asString();
    }

    public String os() {
        return !this.message.contains("os") ? null : this.message.get("os").asString();
    }

    public String jvm() {
        return !this.message.contains("jvm") ? null : this.message.get("jvm").asString();
    }

    public Integer cores() {
        return this.message.get("cores").asInteger();
    }

    public Long diskSize() {
        return this.message.get("diskSize").asLong();
    }

    public Long memorySize() {
        return this.message.get("memorySize").asLong();
    }

    public Integer processes() {
        return this.message.get("processes").asInteger();
    }

    public Integer maxOpenFiles() {
        return this.message.get("maxOpenFiles").asInteger();
    }

    public List<ProcessInfo> processInfoList() {
        if (this.processInfoList != null) {
            return this.processInfoList;
        }
        this.processInfoList = new ArrayList<ProcessInfo>((Collection)this.message.components("ProcessInfo").stream().map(c -> new ProcessInfo((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(ProcessInfo element) {
                super.add(element);
                ServerBoot.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, ProcessInfo element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof ProcessInfo)) {
                    return false;
                }
                super.remove(o);
                ServerBoot.this.message.remove(((ProcessInfo)o).toMessage());
                return true;
            }

            @Override
            public ProcessInfo remove(int index) {
                ProcessInfo type = (ProcessInfo)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super ProcessInfo> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((ProcessInfo)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends ProcessInfo> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends ProcessInfo> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.processInfoList;
    }

    public ServerBoot version(String version) {
        if (version == null) {
            this.message.remove("version");
        } else {
            this.message.set("version", version);
        }
        return this;
    }

    public ServerBoot id(String id) {
        if (id == null) {
            this.message.remove("id");
        } else {
            this.message.set("id", id);
        }
        return this;
    }

    public ServerBoot scope(String scope) {
        if (scope == null) {
            this.message.remove("scope");
        } else {
            this.message.set("scope", scope);
        }
        return this;
    }

    public ServerBoot deployUser(String deployUser) {
        if (deployUser == null) {
            this.message.remove("deployUser");
        } else {
            this.message.set("deployUser", deployUser);
        }
        return this;
    }

    public ServerBoot appsWorkspace(String appsWorkspace) {
        if (appsWorkspace == null) {
            this.message.remove("appsWorkspace");
        } else {
            this.message.set("appsWorkspace", appsWorkspace);
        }
        return this;
    }

    public ServerBoot ip(String ip) {
        if (ip == null) {
            this.message.remove("ip");
        } else {
            this.message.set("ip", ip);
        }
        return this;
    }

    public ServerBoot architecture(String architecture) {
        if (architecture == null) {
            this.message.remove("architecture");
        } else {
            this.message.set("architecture", architecture);
        }
        return this;
    }

    public ServerBoot os(String os) {
        if (os == null) {
            this.message.remove("os");
        } else {
            this.message.set("os", os);
        }
        return this;
    }

    public ServerBoot jvm(String jvm) {
        if (jvm == null) {
            this.message.remove("jvm");
        } else {
            this.message.set("jvm", jvm);
        }
        return this;
    }

    public ServerBoot cores(Integer cores) {
        this.message.set("cores", cores);
        return this;
    }

    public ServerBoot diskSize(Long diskSize) {
        if (diskSize == null) {
            this.message.remove("diskSize");
        } else {
            this.message.set("diskSize", diskSize);
        }
        return this;
    }

    public ServerBoot memorySize(Long memorySize) {
        if (memorySize == null) {
            this.message.remove("memorySize");
        } else {
            this.message.set("memorySize", memorySize);
        }
        return this;
    }

    public ServerBoot processes(Integer processes) {
        this.message.set("processes", processes);
        return this;
    }

    public ServerBoot maxOpenFiles(Integer maxOpenFiles) {
        this.message.set("maxOpenFiles", maxOpenFiles);
        return this;
    }

    public ServerBoot processInfoList(List<ProcessInfo> processInfo) {
        new ArrayList<ProcessInfo>(this.processInfoList()).forEach((Consumer<ProcessInfo>)((Consumer<Object>)v -> this.processInfoList.remove(v)));
        this.processInfoList.addAll(processInfo);
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static class ProcessInfo
    implements Serializable {
        private List<JVMParameter> jVMParameterList = null;
        private List<Artifactory> artifactoryList = null;
        private List<Parameter> parameterList = null;
        protected Message message;

        public ProcessInfo() {
            this.message = new Message("ProcessInfo");
        }

        public ProcessInfo(Message message) {
            this.message = message;
        }

        public String id() {
            return !this.message.contains("id") ? null : this.message.get("id").asString();
        }

        public String classpathPrefix() {
            return !this.message.contains("classpathPrefix") ? null : this.message.get("classpathPrefix").asString();
        }

        public Integer jmxPort() {
            return this.message.get("jmxPort").asInteger();
        }

        public String artifact() {
            return !this.message.contains("artifact") ? null : this.message.get("artifact").asString();
        }

        public Integer minMemory() {
            return this.message.get("minMemory").asInteger();
        }

        public Integer maxMemory() {
            return this.message.get("maxMemory").asInteger();
        }

        public List<JVMParameter> jVMParameterList() {
            if (this.jVMParameterList != null) {
                return this.jVMParameterList;
            }
            this.jVMParameterList = new ArrayList<JVMParameter>((Collection)this.message.components("JVMParameter").stream().map(c -> new JVMParameter((Message)c)).collect(Collectors.toList())){

                @Override
                public boolean add(JVMParameter element) {
                    super.add(element);
                    message.add(element.toMessage());
                    return true;
                }

                @Override
                public void add(int index, JVMParameter element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof JVMParameter)) {
                        return false;
                    }
                    super.remove(o);
                    message.remove(((JVMParameter)o).toMessage());
                    return true;
                }

                @Override
                public JVMParameter remove(int index) {
                    JVMParameter type = (JVMParameter)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super JVMParameter> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((JVMParameter)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends JVMParameter> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends JVMParameter> c) {
                    throw new UnsupportedOperationException();
                }
            };
            return this.jVMParameterList;
        }

        public List<Artifactory> artifactoryList() {
            if (this.artifactoryList != null) {
                return this.artifactoryList;
            }
            this.artifactoryList = new ArrayList<Artifactory>((Collection)this.message.components("Artifactory").stream().map(c -> new Artifactory((Message)c)).collect(Collectors.toList())){

                @Override
                public boolean add(Artifactory element) {
                    super.add(element);
                    message.add(element.toMessage());
                    return true;
                }

                @Override
                public void add(int index, Artifactory element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Artifactory)) {
                        return false;
                    }
                    super.remove(o);
                    message.remove(((Artifactory)o).toMessage());
                    return true;
                }

                @Override
                public Artifactory remove(int index) {
                    Artifactory type = (Artifactory)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super Artifactory> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Artifactory)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends Artifactory> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends Artifactory> c) {
                    throw new UnsupportedOperationException();
                }
            };
            return this.artifactoryList;
        }

        public List<Parameter> parameterList() {
            if (this.parameterList != null) {
                return this.parameterList;
            }
            this.parameterList = new ArrayList<Parameter>((Collection)this.message.components("Parameter").stream().map(c -> new Parameter((Message)c)).collect(Collectors.toList())){

                @Override
                public boolean add(Parameter element) {
                    super.add(element);
                    message.add(element.toMessage());
                    return true;
                }

                @Override
                public void add(int index, Parameter element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Parameter)) {
                        return false;
                    }
                    super.remove(o);
                    message.remove(((Parameter)o).toMessage());
                    return true;
                }

                @Override
                public Parameter remove(int index) {
                    Parameter type = (Parameter)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super Parameter> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Parameter)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends Parameter> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends Parameter> c) {
                    throw new UnsupportedOperationException();
                }
            };
            return this.parameterList;
        }

        public ProcessInfo id(String id) {
            if (id == null) {
                this.message.remove("id");
            } else {
                this.message.set("id", id);
            }
            return this;
        }

        public ProcessInfo classpathPrefix(String classpathPrefix) {
            if (classpathPrefix == null) {
                this.message.remove("classpathPrefix");
            } else {
                this.message.set("classpathPrefix", classpathPrefix);
            }
            return this;
        }

        public ProcessInfo jmxPort(Integer jmxPort) {
            this.message.set("jmxPort", jmxPort);
            return this;
        }

        public ProcessInfo artifact(String artifact) {
            if (artifact == null) {
                this.message.remove("artifact");
            } else {
                this.message.set("artifact", artifact);
            }
            return this;
        }

        public ProcessInfo minMemory(Integer minMemory) {
            this.message.set("minMemory", minMemory);
            return this;
        }

        public ProcessInfo maxMemory(Integer maxMemory) {
            this.message.set("maxMemory", maxMemory);
            return this;
        }

        public ProcessInfo jVMParameterList(List<JVMParameter> jVMParameter) {
            new ArrayList<JVMParameter>(this.jVMParameterList()).forEach((Consumer<JVMParameter>)((Consumer<Object>)v -> this.jVMParameterList.remove(v)));
            this.jVMParameterList.addAll(jVMParameter);
            return this;
        }

        public ProcessInfo artifactoryList(List<Artifactory> artifactory) {
            new ArrayList<Artifactory>(this.artifactoryList()).forEach((Consumer<Artifactory>)((Consumer<Object>)v -> this.artifactoryList.remove(v)));
            this.artifactoryList.addAll(artifactory);
            return this;
        }

        public ProcessInfo parameterList(List<Parameter> parameter) {
            new ArrayList<Parameter>(this.parameterList()).forEach((Consumer<Parameter>)((Consumer<Object>)v -> this.parameterList.remove(v)));
            this.parameterList.addAll(parameter);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static class Parameter
        implements Serializable {
            protected Message message;

            public Parameter() {
                this.message = new Message("Parameter");
            }

            public Parameter(Message message) {
                this.message = message;
            }

            public String name() {
                return !this.message.contains("name") ? null : this.message.get("name").asString();
            }

            public String value() {
                return !this.message.contains("value") ? null : this.message.get("value").asString();
            }

            public Parameter name(String name) {
                if (name == null) {
                    this.message.remove("name");
                } else {
                    this.message.set("name", name);
                }
                return this;
            }

            public Parameter value(String value) {
                if (value == null) {
                    this.message.remove("value");
                } else {
                    this.message.set("value", value);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }

        public static class Artifactory
        implements Serializable {
            protected Message message;

            public Artifactory() {
                this.message = new Message("Artifactory");
            }

            public Artifactory(Message message) {
                this.message = message;
            }

            public String id() {
                return !this.message.contains("id") ? null : this.message.get("id").asString();
            }

            public String url() {
                return !this.message.contains("url") ? null : this.message.get("url").asString();
            }

            public String user() {
                return !this.message.contains("user") ? null : this.message.get("user").asString();
            }

            public String password() {
                return !this.message.contains("password") ? null : this.message.get("password").asString();
            }

            public Artifactory id(String id) {
                if (id == null) {
                    this.message.remove("id");
                } else {
                    this.message.set("id", id);
                }
                return this;
            }

            public Artifactory url(String url) {
                if (url == null) {
                    this.message.remove("url");
                } else {
                    this.message.set("url", url);
                }
                return this;
            }

            public Artifactory user(String user) {
                if (user == null) {
                    this.message.remove("user");
                } else {
                    this.message.set("user", user);
                }
                return this;
            }

            public Artifactory password(String password) {
                if (password == null) {
                    this.message.remove("password");
                } else {
                    this.message.set("password", password);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }

        public static class JVMParameter
        implements Serializable {
            protected Message message;

            public JVMParameter() {
                this.message = new Message("JVMParameter");
            }

            public JVMParameter(Message message) {
                this.message = message;
            }

            public String value() {
                return !this.message.contains("value") ? null : this.message.get("value").asString();
            }

            public JVMParameter value(String value) {
                if (value == null) {
                    this.message.remove("value");
                } else {
                    this.message.set("value", value);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }
        }
    }
}

